/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdenver.ccp.nlp.biolemmatizer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Americanize {
    private static final int MINIMUM_LENGTH_CHANGED = 4;
    private static final int MINIMUM_LENGTH_PATTERN_MATCH = 6;
    private Map<String, String> mappingBritishtoAmerican;
    private static final String[] patStrings = new String[]{"(ph|an|h|gyn|arch|chim)ae", "haem(at)?o", "aemia$", "([lL])eukaem", "programme(s?)$", "^([a-z]{3,})our(s?)$"};
    private static final String[] reps = new String[]{"$1e", "hem$1o", "emia", "$1eukem", "program$1", "$1or$2"};
    private static final Pattern[] pats = new Pattern[patStrings.length];
    private static final Pattern disjunctivePattern;
    private static final String[] OUR_EXCEPTIONS;
    private static final Pattern[] excepts;

    public Americanize() {
        String mappingFileName = "BritishToAmerican.mapping";
        InputStream is = Americanize.class.getResourceAsStream(mappingFileName);
        try {
            this.mappingBritishtoAmerican = Americanize.loadSpellingMappingFile(is);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while opening mapping file: " + mappingFileName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> loadSpellingMappingFile(InputStream is) throws IOException {
        HashMap<String, String> mapping = new HashMap<String, String>();
        try {
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader input = new BufferedReader(isr);
            String line = null;
            while ((line = input.readLine()) != null) {
                line = line.trim();
                String[] pair = line.split("\t");
                mapping.put(pair[0], pair[1]);
            }
            input.close();
            isr.close();
        }
        finally {
            is.close();
        }
        return mapping;
    }

    public String americanize(String str) {
        int length = str.length();
        if (length < 4) {
            return str;
        }
        String result = this.mappingBritishtoAmerican.get(str);
        if (result != null) {
            return result;
        }
        if (length < 6) {
            return str;
        }
        if (!disjunctivePattern.matcher(str).find()) {
            return str;
        }
        for (int i = 0; i < pats.length; ++i) {
            Matcher me;
            Pattern ex;
            Matcher m3 = pats[i].matcher(str);
            if (!m3.find() || (ex = excepts[i]) != null && (me = ex.matcher(str)).find()) continue;
            return m3.replaceAll(reps[i]);
        }
        return str;
    }

    public static final String join(String[] s2, String delimiter) {
        if (s2.length == 0) {
            return "";
        }
        Iterator<String> iter = Arrays.asList(s2).iterator();
        StringBuffer buffer = new StringBuffer(iter.next());
        while (iter.hasNext()) {
            buffer.append(delimiter).append(iter.next());
        }
        return buffer.toString();
    }

    public static void main(String[] args) throws IOException {
        Americanize convert = new Americanize();
        if (args.length == 0) {
            String line;
            BufferedReader buf = new BufferedReader(new InputStreamReader(System.in));
            while ((line = buf.readLine()) != null) {
                for (String w : line.split("\\s+")) {
                    System.out.print(convert.americanize(w));
                    System.out.print(' ');
                }
                System.out.println();
            }
            buf.close();
        }
        for (String arg : args) {
            System.out.print(arg);
            System.out.print(" --> ");
            System.out.println(convert.americanize(arg));
        }
    }

    static {
        StringBuilder foo = new StringBuilder();
        int len = pats.length;
        for (int i = 0; i < len; ++i) {
            Americanize.pats[i] = Pattern.compile(patStrings[i]);
            if (i > 0) {
                foo.append('|');
            }
            foo.append("(?:");
            foo.append(patStrings[i].replaceAll("[()]", ""));
            foo.append(')');
        }
        disjunctivePattern = Pattern.compile(foo.toString());
        OUR_EXCEPTIONS = new String[]{"abatjour", "beflour", "bonjour", "calambour", "carrefour", "cornflour", "contour", "de[tv]our", "dortour", "dyvour", "downpour", "giaour", "glamour", "holour", "inpour", "outpour", "pandour", "paramour", "pompadour", "recontour", "repour", "ryeflour", "sompnour", "tambour", "troubadour", "tregetour", "velour"};
        excepts = new Pattern[]{null, null, null, null, null, Pattern.compile(Americanize.join(OUR_EXCEPTIONS, "|"))};
    }
}

