/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.xml;

import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.SetFactory;
import java.util.Map;
import java.util.Set;

public class XMLTagClassifier {
    protected Set<String> jumpTagsSet = SetFactory.createNewSet();
    protected Set<String> softTagsSet = SetFactory.createNewSet();
    protected Map<String, String> tagClasses = MapFactory.createNewMap();

    public XMLTagClassifier() {
    }

    public XMLTagClassifier(String jumpTags, String softTags, boolean ignoreCase) {
        this.setJumpTags(jumpTags, ignoreCase);
        this.setSoftTags(softTags, ignoreCase);
    }

    public void setJumpTags(String tags, boolean ignoreCase) {
        this.setJumpTags(tags.split("\\s"), ignoreCase);
    }

    public void setJumpTags(String[] tags, boolean ignoreCase) {
        this.jumpTagsSet.clear();
        for (int i = 0; i < tags.length; ++i) {
            if (tags[i].length() <= 0) continue;
            String tag = tags[i];
            if (ignoreCase) {
                tag = tag.toLowerCase();
            }
            this.jumpTagsSet.add(tag);
        }
    }

    public void setSoftTags(String tags, boolean ignoreCase) {
        this.setSoftTags(tags.split("\\s"), ignoreCase);
    }

    public void setSoftTags(String[] tags, boolean ignoreCase) {
        this.softTagsSet.clear();
        for (int i = 0; i < tags.length; ++i) {
            if (tags[i].length() <= 0) continue;
            String tag = tags[i];
            if (ignoreCase) {
                tag = tag.toLowerCase();
            }
            this.softTagsSet.add(tag);
        }
    }

    public void setTagClass(String tagClass, String[] tags, boolean ignoreCase) {
        for (int i = 0; i < tags.length; ++i) {
            if (tags[i].length() <= 0) continue;
            String tag = tags[i];
            if (ignoreCase) {
                tag = tag.toLowerCase();
            }
            this.tagClasses.put(tag, tagClass);
        }
    }

    public void setTagClass(String tagClass, String tags, boolean ignoreCase) {
        this.setTagClass(tagClass, tags.split("\\s"), ignoreCase);
    }

    public String getTagClass(String tag) {
        String tagClass = this.tagClasses.get(tag);
        if (tagClass == null) {
            tagClass = this.tagClasses.get(tag.toLowerCase());
        }
        return tagClass;
    }

    public boolean isSoftTag(String tag) {
        return this.softTagsSet.contains(tag) || this.softTagsSet.contains(tag.toLowerCase());
    }

    public boolean isJumpTag(String tag) {
        return this.jumpTagsSet.contains(tag) || this.jumpTagsSet.contains(tag.toLowerCase());
    }

    public boolean isHardTag(String tag) {
        return !this.isSoftTag(tag) && !this.isJumpTag(tag);
    }
}

