/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.xml;

import com.megginson.sax.XMLWriter;
import edu.northwestern.at.utils.Env;
import edu.northwestern.at.utils.QueueStack;
import java.io.Writer;
import java.util.Arrays;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class IndentingXMLWriter
extends XMLWriter {
    protected int indentStep = 0;
    protected char[] indents = new char[0];
    protected char[] eol = Env.LINE_SEPARATOR.toCharArray();
    protected QueueStack<Boolean> childStack = new QueueStack();

    public IndentingXMLWriter(XMLReader xmlReader, Writer writer) {
        super(xmlReader, writer);
    }

    public int getIndentStep() {
        return this.indentStep;
    }

    public void setIndentStep(int indentStep) {
        this.indentStep = indentStep;
        if (indentStep > 0) {
            this.indents = new char[indentStep];
            Arrays.fill(this.indents, ' ');
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        super.ignorableWhitespace(this.eol, 0, this.eol.length);
        if (this.indentStep > 0) {
            for (int i = 0; i < this.childStack.size(); ++i) {
                super.ignorableWhitespace(this.indents, 0, this.indents.length);
            }
        }
        if (!this.childStack.isEmpty()) {
            this.childStack.pop();
            this.childStack.push(true);
        }
        this.childStack.push(false);
        super.startElement(uri, localName, qName, atts);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        boolean hadChildElement = this.childStack.pop();
        if (hadChildElement) {
            super.ignorableWhitespace(this.eol, 0, this.eol.length);
            if (this.indentStep > 0) {
                for (int i = 0; i < this.childStack.size(); ++i) {
                    super.ignorableWhitespace(this.indents, 0, this.indents.length);
                }
            }
        }
        super.endElement(uri, localName, qName);
    }
}

