/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.spellcheck.tools;

import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.corpuslinguistics.phonetics.DoubleMetaphone;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class makedict {
    public static void main(String[] args) {
        String dictionaryText = args[0];
        String dictionaryName = args[1];
        TreeMap<String, String> dictionary = new TreeMap<String, String>();
        TreeMap<String, List<String>> metaphones = new TreeMap<String, List<String>>();
        DoubleMetaphone metaphone = new DoubleMetaphone();
        try {
            int nWords = 0;
            try {
                String word;
                BufferedReader in = new BufferedReader(new FileReader(dictionaryText));
                while ((word = in.readLine()) != null) {
                    String lowerCaseWord = word.toLowerCase();
                    String metaphoneValue = "";
                    try {
                        metaphoneValue = metaphone.encode(lowerCaseWord);
                    }
                    catch (Exception e) {
                        metaphoneValue = "";
                    }
                    if (dictionary.get(lowerCaseWord) != null) continue;
                    dictionary.put(lowerCaseWord, metaphoneValue);
                    List<String> words = (List<String>)metaphones.get(metaphoneValue);
                    if (words == null) {
                        words = ListFactory.createNewList();
                    }
                    words.add(lowerCaseWord);
                    metaphones.put(metaphoneValue, words);
                    if (++nWords / 1000 * 1000 != nWords) continue;
                    System.out.println(nWords);
                }
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            nWords = dictionary.size();
            int nMeta = metaphones.size();
            BufferedWriter out = new BufferedWriter(new FileWriter(dictionaryName));
            out.write(nWords + "\n");
            out.write(nMeta + "\n");
            ArrayList keys = new ArrayList(metaphones.keySet());
            for (String key : keys) {
                out.write(key + "\n");
                List words = (List)metaphones.get(key);
                if (words == null) {
                    out.write("0\n");
                    continue;
                }
                out.write(words.size() + "\n");
                for (int i = 0; i < words.size(); ++i) {
                    key = (String)words.get(i);
                    out.write(key + "\n");
                }
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

