/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.spellcheck;

import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.corpuslinguistics.stringsimilarity.LevensteinDistance;
import edu.northwestern.at.utils.spellcheck.HashMapSpellingDictionary;
import edu.northwestern.at.utils.spellcheck.SpellingChecker;
import edu.northwestern.at.utils.spellcheck.SpellingDictionary;
import edu.northwestern.at.utils.spellcheck.TernaryTrieSpellingDictionary;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TernaryTrieBasedSpellingChecker
implements SpellingChecker {
    protected SpellingDictionary globalDictionary = null;
    protected SpellingDictionary localDictionary = null;
    protected SpellingDictionary ignoreList = new HashMapSpellingDictionary();

    public TernaryTrieBasedSpellingChecker(SpellingDictionary globalDictionary, SpellingDictionary localDictionary) {
        this.globalDictionary = globalDictionary;
        this.localDictionary = localDictionary;
    }

    public TernaryTrieBasedSpellingChecker(SpellingDictionary globalDictionary) {
        this.globalDictionary = globalDictionary;
        this.localDictionary = null;
    }

    public TernaryTrieBasedSpellingChecker() {
        this.globalDictionary = null;
        this.localDictionary = null;
    }

    @Override
    public void useGlobalDictionary(SpellingDictionary dictionary) {
        this.globalDictionary = dictionary;
    }

    @Override
    public void useLocalDictionary(SpellingDictionary dictionary) {
        this.localDictionary = dictionary;
    }

    private boolean addWordToDictionary(String word, SpellingDictionary dictionary) {
        return dictionary.addWord(word);
    }

    @Override
    public boolean checkSpelling(String word) {
        if (word == null || word.length() <= 0) {
            return true;
        }
        if (word.equals(word.toUpperCase())) {
            return true;
        }
        if (Character.isDigit(word.charAt(0))) {
            return true;
        }
        String lowerCaseWord = word.toLowerCase();
        return this.ignoreList.lookupWord(lowerCaseWord) || this.localDictionary != null && this.localDictionary.lookupWord(lowerCaseWord) || this.globalDictionary != null && this.globalDictionary.lookupWord(lowerCaseWord);
    }

    private List<String> pruneSuggestions(String word, List<String> suggestions) {
        int nSuggestions = suggestions.size();
        List<String> result = ListFactory.createNewList(nSuggestions);
        for (int i = 0; i < nSuggestions; ++i) {
            String suggestedWord = suggestions.get(i);
            if (!LevensteinDistance.areAlike(word, suggestedWord)) continue;
            result.add(suggestedWord);
        }
        return result;
    }

    private void addWords(Map<String, Integer> map, List<String> words) {
        if (words == null || words.size() == 0) {
            return;
        }
        for (int i = 0; i < words.size(); ++i) {
            String word = words.get(i);
            if (map.containsKey(word)) continue;
            map.put(word, new Integer(1));
        }
    }

    public String[] suggest(String word, boolean prune) {
        Set<String> suggestions = this.globalDictionary.getRelatedWords(word);
        if (this.localDictionary != null) {
            suggestions.addAll(this.localDictionary.getRelatedWords(word));
        }
        return suggestions.toArray(new String[suggestions.size()]);
    }

    public String[] suggestMore(String word, boolean prune) {
        Set<String> suggestions = ((TernaryTrieSpellingDictionary)this.globalDictionary).getMoreRelatedWords(word);
        if (this.localDictionary != null) {
            suggestions.addAll(((TernaryTrieSpellingDictionary)this.localDictionary).getMoreRelatedWords(word));
        }
        return suggestions.toArray(new String[0]);
    }

    @Override
    public String[] suggest(String word) {
        return this.suggest(word, false);
    }

    public String[] suggestMore(String word) {
        return this.suggestMore(word, false);
    }

    @Override
    public boolean addWordToLocalDictionary(String word) {
        if (this.localDictionary != null) {
            return this.localDictionary.addWord(word);
        }
        return false;
    }

    @Override
    public boolean addWordToGlobalDictionary(String word) {
        return false;
    }

    @Override
    public boolean addWordToIgnoreList(String word) {
        return this.ignoreList.addWord(word);
    }

    @Override
    public void emptyIgnoreList() {
        this.ignoreList.clear();
    }
}

