/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.spellcheck;

import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.SetFactory;
import edu.northwestern.at.utils.corpuslinguistics.phonetics.DoubleMetaphone;
import edu.northwestern.at.utils.corpuslinguistics.stringsimilarity.LevensteinDistance;
import edu.northwestern.at.utils.spellcheck.HashMapSpellingDictionary;
import edu.northwestern.at.utils.spellcheck.SpellingChecker;
import edu.northwestern.at.utils.spellcheck.SpellingDictionary;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMindedSpellingChecker
implements SpellingChecker {
    private SpellingDictionary globalDictionary = null;
    private SpellingDictionary localDictionary = null;
    private SpellingDictionary ignoreList = new HashMapSpellingDictionary();
    private DoubleMetaphone metaphone = new DoubleMetaphone();

    public SimpleMindedSpellingChecker(SpellingDictionary globalDictionary, SpellingDictionary localDictionary) {
        this.globalDictionary = globalDictionary;
        this.localDictionary = localDictionary;
    }

    public SimpleMindedSpellingChecker(SpellingDictionary globalDictionary) {
        this.globalDictionary = globalDictionary;
        this.localDictionary = null;
    }

    public SimpleMindedSpellingChecker() {
        this.globalDictionary = null;
        this.localDictionary = null;
    }

    @Override
    public void useGlobalDictionary(SpellingDictionary dictionary) {
        this.globalDictionary = dictionary;
    }

    @Override
    public void useLocalDictionary(SpellingDictionary dictionary) {
        this.localDictionary = dictionary;
    }

    private boolean addWordToDictionary(String word, SpellingDictionary dictionary) {
        return dictionary.addWord(word);
    }

    @Override
    public boolean checkSpelling(String word) {
        if (word == null || word.length() <= 0) {
            return true;
        }
        if (word.equals(word.toUpperCase())) {
            return true;
        }
        if (Character.isDigit(word.charAt(0))) {
            return true;
        }
        String lowerCaseWord = word.toLowerCase();
        return this.ignoreList.lookupWord(lowerCaseWord) || this.localDictionary != null && this.localDictionary.lookupWord(lowerCaseWord) || this.globalDictionary != null && this.globalDictionary.lookupWord(lowerCaseWord);
    }

    private Set<String> pruneSuggestions(String word, Collection<String> suggestions) {
        int nSuggestions = suggestions.size();
        Set<String> result = SetFactory.createNewSet();
        for (String suggestedWord : suggestions) {
            if (!LevensteinDistance.areAlike(word, suggestedWord)) continue;
            result.add(suggestedWord);
        }
        return result;
    }

    private void addWords(Map<String, Integer> map, Collection<String> words) {
        if (words == null || words.size() == 0) {
            return;
        }
        for (String word : words) {
            if (map.containsKey(word)) continue;
            map.put(word, new Integer(1));
        }
    }

    public String[] suggest(String word, boolean prune) {
        String lowerCaseWord = word.toLowerCase();
        boolean startsWithCapital = Character.isUpperCase(word.charAt(0));
        String[] result = null;
        try {
            String metaphoneValue = this.metaphone.encode(lowerCaseWord);
            String metaphoneValue2 = this.metaphone.getAlternate();
            TreeMap<String, Integer> combinedSuggestions = new TreeMap<String, Integer>();
            if (this.globalDictionary != null) {
                this.addWords(combinedSuggestions, this.globalDictionary.getRelatedWords(metaphoneValue));
            }
            if (this.localDictionary != null) {
                this.addWords(combinedSuggestions, this.localDictionary.getRelatedWords(metaphoneValue));
            }
            this.addWords(combinedSuggestions, this.ignoreList.getRelatedWords(metaphoneValue));
            if (!metaphoneValue2.equals(metaphoneValue)) {
                if (this.globalDictionary != null) {
                    this.addWords(combinedSuggestions, this.globalDictionary.getRelatedWords(metaphoneValue2));
                }
                if (this.localDictionary != null) {
                    this.addWords(combinedSuggestions, this.localDictionary.getRelatedWords(metaphoneValue2));
                }
                this.addWords(combinedSuggestions, this.ignoreList.getRelatedWords(metaphoneValue2));
            }
            Set<String> suggestions = SetFactory.createNewSet(combinedSuggestions.size());
            List<String> keys = ListFactory.createNewList();
            keys.addAll(combinedSuggestions.keySet());
            Iterator<Object> iterator = keys.iterator();
            while (iterator.hasNext()) {
                suggestions.add((String)iterator.next());
            }
            if (suggestions != null) {
                if (prune) {
                    suggestions = this.pruneSuggestions(lowerCaseWord, suggestions);
                }
                int nSuggestions = suggestions.size();
                result = new String[nSuggestions];
                iterator = suggestions.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    result[i] = (String)iterator.next();
                    if (startsWithCapital) {
                        result[i] = Character.toUpperCase(result[i].charAt(0)) + result[i].substring(1);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return result;
    }

    @Override
    public String[] suggest(String word) {
        return this.suggest(word, true);
    }

    @Override
    public boolean addWordToLocalDictionary(String word) {
        if (this.localDictionary != null) {
            return this.localDictionary.addWord(word);
        }
        return false;
    }

    @Override
    public boolean addWordToGlobalDictionary(String word) {
        return false;
    }

    @Override
    public boolean addWordToIgnoreList(String word) {
        return this.ignoreList.addWord(word);
    }

    @Override
    public void emptyIgnoreList() {
        this.ignoreList.clear();
    }
}

