/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.spellcheck;

import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.SetFactory;
import edu.northwestern.at.utils.corpuslinguistics.phonetics.DoubleMetaphone;
import edu.northwestern.at.utils.spellcheck.SpellingDictionary;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashMapSpellingDictionary
implements SpellingDictionary {
    protected Map<String, List<String>> metaphoneDictionary = MapFactory.createNewMap();
    private DoubleMetaphone metaphone = new DoubleMetaphone();

    public void read(BufferedReader in) throws IOException {
        String metaphoneValue;
        String sWords = in.readLine();
        int nWords = new Integer(sWords);
        String sMeta = in.readLine();
        int nMeta = new Integer(sMeta);
        this.metaphoneDictionary = MapFactory.createNewMap();
        while ((metaphoneValue = in.readLine()) != null) {
            String sWordsThisMeta = in.readLine();
            int nWordsThisMeta = new Integer(sWordsThisMeta);
            List<String> words = ListFactory.createNewList();
            for (int i = 0; i < nWordsThisMeta; ++i) {
                String word = in.readLine();
                words.add(word);
            }
            Collections.sort(words);
            this.metaphoneDictionary.put(metaphoneValue, words);
        }
        in.close();
    }

    public int wordCount() {
        int result = 0;
        List<String> keys = ListFactory.createNewList(this.metaphoneDictionary.keySet());
        for (String key : keys) {
            List<String> words = this.metaphoneDictionary.get(key);
            if (words == null) continue;
            result += words.size();
        }
        return result;
    }

    public void write(BufferedWriter out) throws IOException {
        int nWords = this.wordCount();
        int nMeta = this.metaphoneDictionary.size();
        out.write(nWords + "\n");
        out.write(nMeta + "\n");
        List<String> keys = ListFactory.createNewList(this.metaphoneDictionary.keySet());
        for (String key : keys) {
            List<String> words = this.metaphoneDictionary.get(key);
            out.write(key + "\n");
            if (words == null) {
                out.write("0\n");
                continue;
            }
            out.write(words.size() + "\n");
            for (int i = 0; i < words.size(); ++i) {
                out.write(words.get(i) + "\n");
            }
        }
        out.close();
    }

    @Override
    public boolean lookupWord(String word) {
        if (word == null || word.length() <= 0) {
            return true;
        }
        String lowerCaseWord = word.toLowerCase();
        String metaphoneValue = "";
        try {
            metaphoneValue = this.metaphone.encode(lowerCaseWord);
        }
        catch (Exception e) {
            metaphoneValue = "";
        }
        Set<String> words = this.getRelatedWords(metaphoneValue);
        if (words == null) {
            return false;
        }
        return words.contains(lowerCaseWord);
    }

    private boolean addWordPrivate(String word) {
        String lowerCaseWord = word.toLowerCase();
        String metaphoneValue = "";
        String metaphoneValue2 = "";
        if (this.lookupWord(lowerCaseWord)) {
            return false;
        }
        try {
            metaphoneValue = this.metaphone.encode(lowerCaseWord);
        }
        catch (Exception e) {
            metaphoneValue = "";
        }
        List<String> words = this.metaphoneDictionary.get(metaphoneValue);
        if (words == null) {
            words = ListFactory.createNewList();
        }
        words.add(lowerCaseWord);
        Collections.sort(words);
        this.metaphoneDictionary.put(metaphoneValue, words);
        try {
            metaphoneValue2 = this.metaphone.getAlternate();
        }
        catch (Exception e) {
            metaphoneValue2 = "";
        }
        if (!metaphoneValue2.equals(metaphoneValue)) {
            words = this.metaphoneDictionary.get(metaphoneValue2);
            if (words == null) {
                words = ListFactory.createNewList();
            }
            words.add(lowerCaseWord);
            Collections.sort(words);
            this.metaphoneDictionary.put(metaphoneValue2, words);
        }
        return true;
    }

    @Override
    public boolean addWord(String word) {
        return this.addWordPrivate(word);
    }

    @Override
    public boolean addWords(String[] words) {
        boolean result = true;
        for (int i = 0; i < words.length; ++i) {
            boolean added = this.addWord(words[i]);
            result = result && added;
        }
        return result;
    }

    @Override
    public Set<String> getRelatedWords(String metaphone) {
        Set<String> result = SetFactory.createNewSet();
        List<String> list = this.metaphoneDictionary.get(metaphone);
        if (list != null) {
            result.addAll(list);
        }
        return result;
    }

    @Override
    public Set<String> getAllWords() {
        TreeSet<String> result = new TreeSet<String>();
        List<String> keys = ListFactory.createNewList(this.metaphoneDictionary.keySet());
        for (String key : keys) {
            List<String> words = this.metaphoneDictionary.get(key);
            if (words == null) continue;
            result.addAll(words);
        }
        return result;
    }

    @Override
    public int getNumberOfWords() {
        return this.wordCount();
    }

    @Override
    public void clear() {
        this.metaphoneDictionary.clear();
    }
}

