/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.preprocessor;

import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.StringUtils;
import edu.northwestern.at.utils.UnicodeReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.EmptyStackException;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class Preprocessor {
    protected Map<String, String> definedSymbols = new TreeMap<String, String>();
    protected boolean skipState = false;
    protected Stack<Boolean> skipStates = new Stack();
    protected int lineCount = 0;
    protected BufferedWriter outputWriter = null;
    protected String sourceFileName = null;
    protected String destFileName = null;
    protected String directiveLeadIn = "//#";
    protected String defineDirective = this.directiveLeadIn + "define";
    protected String undefineDirective = this.directiveLeadIn + "undefine";
    protected String includeDirective = this.directiveLeadIn + "include";
    protected String ifdefDirective = this.directiveLeadIn + "ifdef";
    protected String ifndefDirective = this.directiveLeadIn + "ifndef";
    protected String endifDirective = this.directiveLeadIn + "endif";

    public Preprocessor() {
    }

    public Preprocessor(String leadIn) {
        this.directiveLeadIn = leadIn;
        this.defineDirective = this.directiveLeadIn + "define";
        this.undefineDirective = this.directiveLeadIn + "undefine";
        this.includeDirective = this.directiveLeadIn + "include";
        this.ifdefDirective = this.directiveLeadIn + "ifdef";
        this.ifndefDirective = this.directiveLeadIn + "ifndef";
        this.endifDirective = this.directiveLeadIn + "endif";
    }

    protected void defineSymbol(String symbol2, String value) {
        this.definedSymbols.put(symbol2, value);
    }

    protected void undefineSymbol(String symbol2) {
        this.definedSymbols.remove(symbol2);
    }

    protected boolean symbolDefined(String symbol2) {
        return this.definedSymbols.get(symbol2) != null;
    }

    protected String resolve(String s2) {
        for (String symbolName : this.definedSymbols.keySet()) {
            if (s2.indexOf(symbolName) < 0) continue;
            String symbolValue = this.definedSymbols.get(symbolName);
            s2 = StringUtils.replaceAll(s2, symbolName, symbolValue);
        }
        return s2;
    }

    protected void processFile(String sourceFileName, BufferedWriter outputWriter, boolean quiet) throws Exception {
        if (!quiet) {
            System.out.println("   Processing " + sourceFileName);
        }
        BufferedReader inputReader = new BufferedReader(new UnicodeReader(new FileInputStream(sourceFileName), "8859_1"));
        String sourceLine = inputReader.readLine();
        while (sourceLine != null) {
            ++this.lineCount;
            boolean processed = false;
            StringTokenizer tokenizer = new StringTokenizer(sourceLine);
            if (tokenizer.hasMoreTokens()) {
                String symbolName;
                String firstToken = tokenizer.nextToken();
                boolean hasMoreTokens = tokenizer.hasMoreTokens();
                if (firstToken.equals(this.includeDirective)) {
                    if (hasMoreTokens) {
                        String includeFileName = tokenizer.nextToken();
                        includeFileName = includeFileName.replaceAll("\"", "");
                        includeFileName = new File(includeFileName).getAbsolutePath();
                        this.processFile(includeFileName, outputWriter, quiet);
                    }
                    processed = true;
                } else if (firstToken.equals(this.defineDirective)) {
                    if (hasMoreTokens) {
                        symbolName = tokenizer.nextToken();
                        String value = tokenizer.nextToken("");
                        this.defineSymbol(symbolName, value);
                    }
                    processed = true;
                } else if (firstToken.equals(this.undefineDirective)) {
                    if (hasMoreTokens) {
                        this.undefineSymbol(tokenizer.nextToken());
                    }
                    processed = true;
                } else if (firstToken.equals(this.ifdefDirective)) {
                    if (hasMoreTokens) {
                        symbolName = tokenizer.nextToken();
                        this.skipStates.push(new Boolean(this.skipState));
                        this.skipState = !this.symbolDefined(symbolName);
                    }
                    processed = true;
                } else if (firstToken.equals(this.ifndefDirective)) {
                    if (hasMoreTokens) {
                        symbolName = tokenizer.nextToken();
                        this.skipStates.push(new Boolean(this.skipState));
                        this.skipState = this.symbolDefined(symbolName);
                    }
                    processed = true;
                } else if (firstToken.equals(this.endifDirective)) {
                    try {
                        this.skipState = this.skipStates.pop();
                    }
                    catch (EmptyStackException e) {
                        throw new Exception("Mismatched endif at line " + this.lineCount);
                    }
                    processed = true;
                }
            }
            if (!processed && !this.skipState) {
                outputWriter.write(this.resolve(sourceLine));
                outputWriter.newLine();
            }
            sourceLine = inputReader.readLine();
        }
        try {
            if (inputReader != null) {
                inputReader.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!this.skipStates.empty()) {
            throw new Exception("Mismatched endif at line " + this.lineCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preprocess(String sourceFileName, String destFileName, boolean quiet) {
        boolean result = false;
        if (!quiet) {
            System.out.println("Preprocessing " + sourceFileName + " to " + destFileName);
        }
        this.skipState = false;
        this.skipStates = new Stack();
        this.lineCount = 0;
        this.definedSymbols = MapFactory.createNewMap();
        long sourceFileTime = 0L;
        try {
            File sourceFile = new File(sourceFileName);
            sourceFileTime = sourceFile.lastModified();
            this.outputWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destFileName), "8859_1"));
            this.processFile(sourceFileName, this.outputWriter, quiet);
            result = true;
        }
        catch (Exception e) {
            if (!quiet) {
                System.out.println(e.getMessage());
            }
        }
        finally {
            File destFile;
            try {
                if (this.outputWriter != null) {
                    this.outputWriter.close();
                }
            }
            catch (Exception e) {}
            if (result && (destFile = new File(destFileName)) != null) {
                destFile.setLastModified(sourceFileTime);
            }
        }
        return result;
    }

    public boolean preprocess(String sourceFileName, String destFileName) {
        return this.preprocess(sourceFileName, destFileName, false);
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public static void main(String[] args) {
        Preprocessor preproc = new Preprocessor();
        boolean result = preproc.preprocess(args[0], args[1]);
        System.out.println(preproc.getLineCount() + " lines processed.");
        if (!result) {
            System.exit(1);
        }
    }
}

