/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.preprocessor;

import edu.northwestern.at.utils.FileNameUtils;
import edu.northwestern.at.utils.FileUtils;
import edu.northwestern.at.utils.preprocessor.Preprocessor;
import java.io.File;
import java.io.FileFilter;

public class PreprocessDirectoryTree {
    protected static String srcRootName = "";
    protected static String destRootName = "";
    protected static String includeRootName = "";
    protected static int totalJava = 0;
    protected static int totalJavaBad = 0;
    protected static int totalCopied = 0;
    protected static int totalNotCopied = 0;
    protected static boolean verbose = false;

    protected static void runPreprocessor(File src, Preprocessor preprocessor) {
        File[] files = src.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                String name = pathname.getName();
                return name.charAt(0) != '.';
            }
        });
        for (int i = 0; i < files.length; ++i) {
            File file = files[i].getAbsoluteFile();
            if (file.isDirectory()) {
                PreprocessDirectoryTree.runPreprocessor(file, preprocessor);
                continue;
            }
            String srcFilePath = file.getAbsolutePath();
            String srcFileName = file.getAbsoluteFile().getName();
            String srcFileNameExt = FileNameUtils.getFileExtension(srcFileName, false);
            String srcFileDirectory = file.getParent();
            String destFilePath = new File(destRootName + srcFileDirectory.substring(srcRootName.length()), srcFileName).getAbsolutePath();
            if (srcFileNameExt.compareToIgnoreCase("java") == 0) {
                if (!FileUtils.createPathForFile(destFilePath)) {
                    if (verbose) {
                        System.out.println("Could not preprocess " + srcFilePath + " to " + destFilePath);
                    }
                    ++totalJavaBad;
                    continue;
                }
                preprocessor.preprocess(srcFilePath, destFilePath, true);
                if (verbose) {
                    System.out.println("Preprocessed " + srcFilePath + " to " + destFilePath);
                }
                ++totalJava;
                continue;
            }
            if (FileUtils.copyFile(srcFilePath, destFilePath)) {
                if (verbose) {
                    System.out.println("Copied " + srcFilePath + " to " + destFilePath);
                }
                ++totalCopied;
                continue;
            }
            if (verbose) {
                System.out.println("Unable to copy " + srcFilePath + " to " + destFilePath);
            }
            ++totalNotCopied;
        }
    }

    protected static void usage() {
        System.out.println("Usage: java edu.northwestern.at.wordhoard.tools.PreprocessDirectoryTree sourcedirectory destinationdirectory includedirectory");
        System.out.println("");
        System.out.println("     sourcedirectory      -- the root of the source directory tree");
        System.out.println("     destinationdirectory -- the root of the destination directory tree");
        System.out.println("     includedirectory -- the root of the include files directory tree");
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            PreprocessDirectoryTree.usage();
            System.exit(1);
        }
        File srcRoot = new File(args[0]);
        srcRoot = srcRoot.getAbsoluteFile();
        File destRoot = new File(args[1]);
        destRoot = destRoot.getAbsoluteFile();
        File includeRoot = new File(args[2]);
        includeRoot = includeRoot.getAbsoluteFile();
        srcRootName = srcRoot.getAbsolutePath();
        destRootName = destRoot.getAbsolutePath();
        includeRootName = includeRoot.getAbsolutePath();
        if (!srcRoot.isDirectory()) {
            System.out.println(srcRootName + " is not a valid directory.");
            System.exit(1);
        }
        if (!FileUtils.createPath(destRoot)) {
            System.out.println("Unable to access or create output directory " + destRootName);
            System.exit(1);
        }
        String oldDirectory = FileUtils.chdir(includeRootName);
        String currentDirectory = FileUtils.getCurrentDirectory();
        if (!currentDirectory.equals(includeRootName)) {
            System.out.println("Unable to move to include file directory " + includeRootName);
            System.exit(1);
        }
        String dashedLine = "-------------------------------------------------------------------";
        System.out.println(dashedLine);
        System.out.println("Preprocessing directory tree");
        System.out.println("   Source directory            : " + srcRootName);
        System.out.println("   Destination directory       : " + destRootName);
        System.out.println("   Included files directory    : " + includeRootName);
        System.out.println(dashedLine);
        long startTime = System.currentTimeMillis();
        PreprocessDirectoryTree.runPreprocessor(srcRoot, new Preprocessor());
        long endTime = System.currentTimeMillis();
        long procTime = Math.round((double)(endTime - startTime) / 1000.0);
        if (verbose || totalNotCopied > 0) {
            System.out.println(dashedLine);
        }
        System.out.println("   Java files preprocessed     : " + totalJava);
        System.out.println("   Java files not preprocessed : " + totalJavaBad);
        System.out.println("   Non-Java files copied       : " + totalCopied);
        System.out.println("   Files not copied            : " + totalNotCopied);
        System.out.println("   Total time                  : " + procTime + (procTime == 1L ? " second" : " seconds"));
    }
}

