/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.statistics;

import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Accumulator {
    protected long count = 0L;
    protected double mean = 0.0;
    protected double sumOfSquares = 0.0;
    protected double minimum = Double.POSITIVE_INFINITY;
    protected double maximum = Double.NEGATIVE_INFINITY;

    public void addValue(double value) {
        ++this.count;
        double prevMean = this.mean;
        this.mean += (value - this.mean) / (double)this.count;
        this.sumOfSquares += (value - this.mean) * (value - prevMean);
        if (this.minimum > value) {
            this.minimum = value;
        }
        if (this.maximum < value) {
            this.maximum = value;
        }
    }

    public void addValues(Collection<Double> values) {
        if (values != null) {
            for (double value : values) {
                this.addValue(value);
            }
        }
    }

    public void addValues(double[] values) {
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                this.addValue(values[i]);
            }
        }
    }

    public long getCount() {
        return this.count;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getMean() {
        return this.mean;
    }

    public double getVariance() {
        return this.sumOfSquares / (double)this.count;
    }

    public double getStandardDeviation() {
        return Math.sqrt(this.getVariance());
    }

    public double getSumOfSquares() {
        return this.sumOfSquares;
    }
}

