/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.randomnumbers;

import edu.northwestern.at.utils.math.randomnumbers.MersenneTwister;

public class RandomVariable {
    private static MersenneTwister rnd = new MersenneTwister();

    public static double rand() {
        return rnd.nextDouble();
    }

    public static int randInt(int min2, int max) {
        return min2 + new Double(Math.floor((double)(max - min2 + 1) * RandomVariable.rand())).intValue();
    }

    public static double beta(double a, double b) {
        double y;
        double x;
        while ((x = Math.pow(RandomVariable.rand(), 1.0 / a)) + (y = Math.pow(RandomVariable.rand(), 1.0 / b)) > 1.0) {
        }
        return x / (x + y);
    }

    public static boolean binomial(double p) {
        return RandomVariable.rand() < p;
    }

    public static int binomialInteger(double p) {
        return RandomVariable.rand() < p ? 0 : 1;
    }

    public static double cauchy(double median, double stddev) {
        return stddev * Math.tan(Math.PI * (RandomVariable.rand() - 0.5)) + median;
    }

    public static double chisquare(int df) {
        double result = 0.0;
        for (int i = 0; i < df; ++i) {
            double norm = RandomVariable.normal(0.0, 1.0);
            result += norm * norm;
        }
        return result;
    }

    public static double dirac(double[] values, double[] pValues) {
        double[] cumulativePDF = new double[values.length];
        cumulativePDF[0] = pValues[0];
        for (int i = 1; i < values.length; ++i) {
            cumulativePDF[i] = cumulativePDF[i - 1] + pValues[i];
        }
        double random = RandomVariable.rand();
        double result = 0.0;
        for (int i = 0; i < values.length - 1; ++i) {
            if (!(random > cumulativePDF[i]) || !(random < cumulativePDF[i + 1])) continue;
            result = values[i];
        }
        return result;
    }

    public static double exponential(double lambda) {
        return -1.0 / lambda * Math.log(RandomVariable.rand());
    }

    public static double gamma(double alpha, double beta) {
        double z;
        double y;
        double u2;
        double u1;
        double v;
        double w;
        if (alpha < 1.0) {
            double y2;
            double b = (Math.E + alpha) / Math.E;
            while (true) {
                double u12;
                double p;
                if (!((p = b * (u12 = RandomVariable.rand())) > 1.0)) {
                    y2 = Math.pow(p, 1.0 / alpha);
                    double u22 = RandomVariable.rand();
                    if (!(u22 <= Math.exp(-y2))) continue;
                    return beta * y2;
                }
                y2 = -Math.log((beta - p) / alpha);
                double u23 = RandomVariable.rand();
                if (u23 <= Math.pow(y2, alpha - 1.0)) break;
            }
            return beta * y2;
        }
        double a = 1.0 / Math.sqrt(2.0 * alpha - 1.0);
        double b = alpha - Math.log(4.0);
        double q = alpha + 1.0 / a;
        double theta = 4.5;
        double d = 1.0 + Math.log(theta);
        while (!((w = b + q * (v = a * Math.log((u1 = RandomVariable.rand()) / (1.0 - (u2 = RandomVariable.rand())))) + (y = alpha * Math.exp(v))) + d - theta * (z = u1 * u1 * u2) >= 0.0) || !(w >= Math.log(z))) {
        }
        return beta * y;
    }

    public static int geometric(double p) {
        return (int)Math.floor(Math.log(RandomVariable.rand()) / Math.log(1.0 - p));
    }

    public static double logNormal(double mean, double stddev) {
        return mean + stddev * Math.cos(Math.PI * 2 * RandomVariable.rand()) * Math.sqrt(-2.0 * Math.log(RandomVariable.rand()));
    }

    public static int negativebinomial(int s2, double p) {
        int result = 0;
        for (int i = 0; i < s2; ++i) {
            result += RandomVariable.geometric(p);
        }
        return result;
    }

    public static double normal(double mean, double stddev) {
        return mean + stddev * RandomVariable.rand();
    }

    public static int poisson(double lambda) {
        double a = Math.exp(-lambda);
        double b = 1.0;
        int i = 0;
        while (!((b *= RandomVariable.rand()) < a)) {
            ++i;
        }
        return i;
    }

    public static double triangular(double min2, double max) {
        return min2 / 2.0 + (max - min2) * RandomVariable.rand() / 2.0 + min2 / 2.0 + (max - min2) * RandomVariable.rand() / 2.0;
    }

    public static double triangular(double min2, double median, double max) {
        double y = RandomVariable.rand();
        return y < (median - min2) / (max - min2) ? min2 + Math.sqrt(y * (max - min2) * (median - min2)) : max - Math.sqrt((1.0 - y) * (max - min2) * (max - median));
    }

    public static double uniform(double min2, double max) {
        return min2 + (max - min2) * RandomVariable.rand();
    }

    public static double weibull(double eta, double beta) {
        return Math.pow(-Math.log(1.0 - RandomVariable.rand()), 1.0 / beta) / eta;
    }
}

