/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.distributions;

import edu.northwestern.at.utils.math.Constants;
import edu.northwestern.at.utils.math.distributions.Beta;

public class Studentst {
    public static double t(double t, double df) throws IllegalArgumentException {
        double result = 0.0;
        if (!(df > 0.0)) {
            throw new IllegalArgumentException("df <= 0");
        }
        result = Beta.incompleteBeta(df / (df + t * t), df / 2.0, 0.5, Constants.MAXPREC);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double tInverse(double p, double df) throws ArithmeticException, IllegalArgumentException {
        double result = 0.0;
        if (!(df > 0.0)) throw new IllegalArgumentException("df <= 0");
        if (!(p >= 0.0)) throw new IllegalArgumentException("p < 0 or p > 1");
        if (!(p <= 1.0)) throw new IllegalArgumentException("p < 0 or p > 1");
        result = Beta.incompleteBetaInverse(1.0 - p, 0.5, df / 2.0);
        if (!(result >= 0.0)) throw new ArithmeticException("inverse incomplete beta evaluation failed");
        if (!(result < 1.0)) throw new ArithmeticException("inverse incomplete beta evaluation failed");
        return Math.sqrt(result * df / (1.0 - result));
    }

    protected Studentst() {
    }
}

