/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.distributions;

import edu.northwestern.at.utils.math.Constants;
import edu.northwestern.at.utils.math.distributions.Gamma;
import edu.northwestern.at.utils.math.distributions.Normal;

public class ChiSquare {
    public static double chisquare(double chisq, double df) {
        return 1.0 - Gamma.incompleteGamma(chisq / 2.0, df / 2.0);
    }

    public static double chisquareInverse(double p, double df) {
        double s6;
        double s5;
        double s4;
        double s3;
        double s2;
        double b;
        double s1;
        double t;
        double p1;
        double p2;
        double q;
        double a;
        double ch;
        int dPrec = Constants.MAXPREC - 1;
        double epsz = Math.pow(10.0, -dPrec);
        int maxIter = 100;
        if (p < epsz || p > 1.0 - epsz) {
            throw new IllegalArgumentException("p bad");
        }
        if (df <= 0.0) {
            throw new IllegalArgumentException("v bad");
        }
        p = 1.0 - p;
        double xx = df / 2.0;
        double g2 = Gamma.logGamma(xx);
        double c = xx - 1.0;
        if (df < -1.24 * Math.log(p)) {
            ch = Math.pow(p * xx * Math.exp(g2 + xx * Constants.LN2), 1.0 / xx);
            if (ch < epsz) {
                return ch;
            }
        } else if (df <= 0.32) {
            ch = 0.4;
            a = Math.log(1.0 - p);
            do {
                q = ch;
                p1 = 1.0 + ch * (4.67 + ch);
                p2 = ch * (6.73 + ch * (6.66 + ch));
                t = -0.5 + (4.67 + 2.0 * ch) / p1 - (6.73 + ch * (13.32 + 3.0 * ch)) / p2;
            } while (Math.abs(q / (ch -= (1.0 - Math.exp(a + g2 + 0.5 * ch + c * Constants.LN2) * p2 / p1) / t) - 1.0) > 0.01);
        } else {
            double x = Normal.normalInverse(p);
            ch = df * Math.pow(x * Math.sqrt(p1 = 2.0 / (9.0 * df)) + 1.0 - p1, 3.0);
            if (ch > 2.2 * df + 6.0) {
                ch = -2.0 * (Math.log(1.0 - p) - c * Math.log(0.5 * ch) + g2);
            }
        }
        while (Math.abs((q = ch) / (ch += (t = (p2 = p - Gamma.incompleteGamma(p1 = 0.5 * ch, xx, dPrec, maxIter)) * Math.exp(xx * Constants.LN2 + g2 + p1 - c * Math.log(ch))) * (1.0 + 0.5 * t * (s1 = (210.0 + (a = 0.5 * t - (b = t / ch) * c) * (140.0 + a * (105.0 + a * (84.0 + a * (70.0 + 60.0 * a))))) / 420.0) - b * c * (s1 - b * ((s2 = (420.0 + a * (735.0 + a * (966.0 + a * (1141.0 + 1278.0 * a)))) / 2520.0) - b * ((s3 = (210.0 + a * (462.0 + a * (707.0 + 932.0 * a))) / 2520.0) - b * ((s4 = (252.0 + a * (672.0 + 1182.0 * a) + c * (294.0 + a * (889.0 + 1740.0 * a))) / 5040.0) - b * ((s5 = (84.0 + 264.0 * a + c * (175.0 + 606.0 * a)) / 2520.0) - b * (s6 = (120.0 + c * (346.0 + 127.0 * c)) / 5040.0)))))))) - 1.0) > epsz) {
        }
        return ch;
    }

    protected ChiSquare() {
    }
}

