/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.distributions;

import edu.northwestern.at.utils.math.Constants;
import edu.northwestern.at.utils.math.MonadicFunction;
import edu.northwestern.at.utils.math.distributions.Gamma;
import edu.northwestern.at.utils.math.rootfinders.BracketRoot;
import edu.northwestern.at.utils.math.rootfinders.Brent;

public class Beta {
    public static double logBeta(double a, double b) {
        return Gamma.logGamma(a) + Gamma.logGamma(b) - Gamma.logGamma(a + b);
    }

    public static double beta(double a, double b) throws ArithmeticException {
        double result = 1.0;
        double ab = Gamma.gamma(a + b);
        if (ab == 0.0) {
            return result;
        }
        if (a > b) {
            result = Gamma.gamma(a) / ab;
            result *= Gamma.gamma(b);
        } else {
            result = Gamma.gamma(b) / ab;
            result *= Gamma.gamma(a);
        }
        return result;
    }

    public static double incompleteBeta(double x, double alpha, double beta, int dPrec) throws IllegalArgumentException {
        double ahi;
        if (dPrec > Constants.MAXPREC) {
            dPrec = Constants.MAXPREC;
        } else if (dPrec <= 0) {
            dPrec = 1;
        }
        double cPrec = dPrec;
        double epsz = Math.pow(10.0, -dPrec);
        double a = alpha;
        double b = beta;
        boolean qSwap = false;
        double result = -1.0;
        boolean qDoit = true;
        int maxIter = 200;
        if (x <= 0.0) {
            throw new IllegalArgumentException("x <= 0.0");
        }
        if (a <= 0.0) {
            throw new IllegalArgumentException("a <= 0.0");
        }
        if (b <= 0.0) {
            throw new IllegalArgumentException("b <= 0.0");
        }
        result = 1.0;
        if (x >= 1.0) {
            return result;
        }
        if (x > a / (a + b)) {
            x = 1.0 - x;
            a = beta;
            b = alpha;
            qSwap = true;
        }
        if (x != a && x != b && a != b * x / (1.0 - x) && !(Math.abs(a - x * (a + b)) <= epsz)) {
            double c = Gamma.logGamma(a + b) + a * Math.log(x) + b * Math.log(1.0 - x) - Gamma.logGamma(a) - Gamma.logGamma(b) - Math.log(a - x * (a + b));
            if (c < -36.0 && qSwap) {
                return result;
            }
            result = 0.0;
            if (c < -180.0) {
                return result;
            }
        }
        double apb = a + b;
        double zm = 0.0;
        double alo = 0.0;
        double bod = 1.0;
        double bev = 1.0;
        double bhi = 1.0;
        double blo = 1.0;
        double f = ahi = Math.exp(Gamma.logGamma(apb) + a * Math.log(x) + b * Math.log(1.0 - x) - Gamma.logGamma(a + 1.0) - Gamma.logGamma(b));
        int iter = 0;
        boolean qConv = false;
        do {
            double fx = f;
            double zm1 = zm;
            double d1 = a + (zm += 1.0) + zm1;
            double aev = -(a + zm1) * (apb + zm1) * x / d1 / (d1 - 1.0);
            double aod = zm * (b - zm) * x / d1 / (d1 + 1.0);
            alo = bev * ahi + aev * alo;
            blo = bev * bhi + aev * blo;
            ahi = bod * alo + aod * ahi;
            if (Math.abs(bhi = bod * blo + aod * bhi) < Double.MIN_VALUE) {
                bhi = 0.0;
            }
            if (bhi == 0.0) continue;
            f = ahi / bhi;
            boolean bl = qConv = Math.abs((f - fx) / f) < epsz;
        } while (++iter <= maxIter && !qConv);
        result = qSwap ? 1.0 - f : f;
        return result;
    }

    public static double incompleteBeta(double x, double alpha, double beta) throws IllegalArgumentException {
        return Beta.incompleteBeta(x, alpha, beta, Constants.MAXPREC);
    }

    public static double incompleteBetaInverse(final double p, final double alpha, final double beta) throws IllegalArgumentException {
        int maxIter;
        MonadicFunction function;
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha<=0");
        }
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta<=0");
        }
        if (p > 1.0 || p < 0.0) {
            throw new IllegalArgumentException("p < 0 or p > 1");
        }
        if (p == 0.0 || p == 1.0) {
            return 0.0;
        }
        double eps = Math.pow(10.0, -2 * Constants.MAXPREC);
        double[] bracket = new double[]{eps, 1.0 - eps};
        if (BracketRoot.bracketRoot(bracket, function = new MonadicFunction(){

            public double f(double x) {
                return p - Beta.incompleteBeta(x, alpha, beta);
            }
        }, maxIter = 100, 1.6)) {
            return Brent.brent(bracket[0], bracket[1], eps, maxIter, function);
        }
        throw new ArithmeticException("Unable to bracket value");
    }

    protected Beta() {
    }
}

