/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math;

import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberOps {
    protected static final Number intZero = new Integer(0);

    public static int compareNumbers(Number number1, Number number2) {
        double d2;
        if (number1 instanceof Integer && number2 instanceof Integer) {
            int i2;
            int i1 = number1.intValue();
            if (i1 < (i2 = number2.intValue())) {
                return -1;
            }
            if (i1 > i2) {
                return 1;
            }
            return 0;
        }
        double d1 = number1.doubleValue();
        if (d1 < (d2 = number2.doubleValue())) {
            return -1;
        }
        if (d1 > d2) {
            return 1;
        }
        return 0;
    }

    public static int compareToZero(Number number) {
        return NumberOps.compareNumbers(number, intZero);
    }

    public static Number add(Number number1, Number number2) {
        if (number1 instanceof Integer && number2 instanceof Integer) {
            return new Integer((Integer)number1 + (Integer)number2);
        }
        return new Double(number1.doubleValue() + number2.doubleValue());
    }

    public static Number subtract(Number number1, Number number2) {
        if (number1 instanceof Integer && number2 instanceof Integer) {
            return new Integer((Integer)number1 - (Integer)number2);
        }
        return new Double(number1.doubleValue() - number2.doubleValue());
    }

    public static Number multiply(Number number1, Number number2) {
        if (number1 instanceof Integer && number2 instanceof Integer) {
            return new Integer((Integer)number1 * (Integer)number2);
        }
        return new Double(number1.doubleValue() * number2.doubleValue());
    }

    public static Number divide(Number number1, Number number2) {
        if (number1 instanceof Integer && number2 instanceof Integer) {
            return new Integer((Integer)number1 / (Integer)number2);
        }
        return new Double(number1.doubleValue() / number2.doubleValue());
    }

    public static Number modulus(Number number1, Number number2) {
        return new Long(number1.longValue() % number2.longValue());
    }

    public static Number toNumber(String s2) throws NumberFormatException {
        Number result;
        try {
            result = new Integer(s2);
        }
        catch (NumberFormatException e) {
            result = new Double(s2);
        }
        return result;
    }

    public static Number cloneNumber(Number number) {
        Number result = null;
        if (number != null) {
            if (number instanceof Integer) {
                result = new Integer(number.intValue());
            } else if (number instanceof Double) {
                result = new Double(number.doubleValue());
            } else if (number instanceof Long) {
                result = new Long(number.longValue());
            } else if (number instanceof Float) {
                result = new Float(number.floatValue());
            } else if (number instanceof Byte) {
                result = new Byte(number.byteValue());
            } else if (number instanceof Short) {
                result = new Short(number.shortValue());
            } else if (number instanceof BigDecimal) {
                BigDecimal bigDec = (BigDecimal)number;
                result = new BigDecimal(bigDec.unscaledValue(), bigDec.scale());
            } else if (number instanceof BigInteger) {
                BigInteger bigInt = (BigInteger)number;
                byte[] bytes = bigInt.toByteArray();
                result = new BigInteger(bytes);
            }
        }
        return result;
    }
}

