/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math;

import edu.northwestern.at.utils.math.Constants;
import edu.northwestern.at.utils.math.Factorial;
import edu.northwestern.at.utils.math.Polynomial;
import edu.northwestern.at.utils.math.SplitDouble;

public class ArithUtils {
    public static final double EPSILON_SMALL = Constants.MACHEPS / 2.0;
    public static final double EPSILON_LARGE = Constants.MACHEPS;
    private static final double[] COT_COEF = new double[]{0.2402591609829563, -0.016533031601500228, -4.299839193172402E-5, -1.5928322332754105E-7, -6.191093135129349E-10, -2.430197415072646E-12, -9.56093675880008E-15, -3.763537981945806E-17, -1.4816657464674657E-19};
    private static final double[] SINH_COEF = new double[]{0.1730421940471796, 0.08759422192276048, 0.00107947777456713, 6.37484926075E-6, 2.202366404E-8, 4.98794E-11, 7.973E-14, 9.0E-17};
    private static final double[] TANH_COEF = new double[]{-0.2582875664363471, -0.11836106330053497, 0.009869442648006398, -8.35798662344582E-4, 7.0904321198943E-5, -6.01642431812E-6, 5.105241908E-7, -4.3320729077E-8, 3.675999055E-9, -3.11928496E-10, 2.6468828E-11, -2.246023E-12, 1.90587E-13, -1.6172E-14, 1.372E-15, -1.16E-16, 9.0E-18};
    private static final double[] ASINH_COEF = new double[]{-0.12820039911738187, -0.05881176118995177, 0.004727465432212481, -4.938363162653618E-4, 5.850620705855741E-5, -7.466998328931368E-6, 1.00116935835582E-6, -1.3903543858708333E-7, 1.9823169483172795E-8, -2.8847468417848845E-9, 4.2672965467159937E-10, -6.397608465436636E-11, 9.699168608906471E-12, -1.4844276972043772E-12, 2.290373793902745E-13, -3.5588395132732646E-14, 5.563969408005679E-15, -8.746250959962468E-16, 1.381524884452669E-16, -2.1916688282900364E-17, 3.490465852482756E-18};
    private static final double[] ATANH_COEF = new double[]{0.0943951023931955, 0.04919843705578616, 0.002102593522455433, 1.0735544497761166E-4, 5.978267249293031E-6, 3.505062030889135E-7, 2.1263743437653402E-8, 1.3216945357155272E-9, 8.36587550117807E-11, 5.370503749311002E-12, 3.4866594701571077E-13, 2.284549509603433E-14, 1.508407105944793E-15, 1.0024188168041091E-16, 6.69867473816507E-18, 4.497954546494931E-19};

    public static double acosh(double x) {
        double ans = Double.isNaN(x) || x < 1.0 ? Double.NaN : (x < 9.490626562E7 ? ArithUtils.safeLog(x + Math.sqrt(x * x - 1.0)) : 0.6931471805599453 + ArithUtils.safeLog(x));
        return ans;
    }

    public static boolean areEqual(double a, double b) {
        return ArithUtils.areEqual(a, b, Constants.MACHEPS);
    }

    public static boolean areEqual(double a, double b, double tolerance) {
        boolean result;
        boolean bl = result = a == b;
        if (!result) {
            result = a == 0.0 ? Math.abs(b) <= tolerance : (b == 0.0 ? Math.abs(a) <= tolerance : ArithUtils.fuzzyCompare(a, b, tolerance) == 0);
        }
        return result;
    }

    public static double asinh(double x) {
        double y = Math.abs(x);
        double ans = Double.isNaN(x) ? Double.NaN : (y <= 1.05367E-8 ? x : (y <= 1.0 ? x * (1.0 + Polynomial.evaluateChebyschev(ASINH_COEF, 2.0 * x * x - 1.0)) : (y < 9.490626562E7 ? ArithUtils.safeLog(y + Math.sqrt(y * y + 1.0)) : 0.6931471805599453 + ArithUtils.safeLog(y))));
        if (x < 0.0) {
            ans = -ans;
        }
        return ans;
    }

    public static double atanh(double x) {
        double y = Math.abs(x);
        double ans = Double.isNaN(x) ? Double.NaN : (y < 1.82501E-8 ? x : (y <= 0.5 ? x * (1.0 + Polynomial.evaluateChebyschev(ATANH_COEF, 8.0 * x * x - 1.0)) : (y < 1.0 ? 0.5 * ArithUtils.safeLog((1.0 + x) / (1.0 - x)) : (y == 1.0 ? x * Double.POSITIVE_INFINITY : Double.NaN))));
        return ans;
    }

    public static double binomial(double n, long k) {
        if (k < 0L) {
            return 0.0;
        }
        if (k == 0L) {
            return 1.0;
        }
        if (k == 1L) {
            return n;
        }
        double a = n - (double)k + 1.0;
        double b = 1.0;
        double binomial = 1.0;
        long i = k;
        while (i-- > 0L) {
            double d = a;
            a = d + 1.0;
            double d2 = b;
            b = d2 + 1.0;
            binomial *= d / d2;
        }
        return binomial;
    }

    public static double binomial(long n, long k) {
        if (k < 0L) {
            return 0.0;
        }
        if (k == 0L || k == n) {
            return 1.0;
        }
        if (k == 1L || k == n - 1L) {
            return n;
        }
        if (n > k) {
            int max = Factorial.longFactorials.length + Factorial.doubleFactorials.length;
            if (n < (long)max) {
                double n_fac = Factorial.factorial((int)n);
                double k_fac = Factorial.factorial((int)k);
                double n_minus_k_fac = Factorial.factorial((int)(n - k));
                double nk = n_minus_k_fac * k_fac;
                if (nk != Double.POSITIVE_INFINITY) {
                    return n_fac / nk;
                }
            }
            if (k > n / 2L) {
                k = n - k;
            }
        }
        long a = n - k + 1L;
        long b = 1L;
        double binomial = 1.0;
        long i = k;
        while (i-- > 0L) {
            binomial *= (double)a++ / (double)b++;
        }
        return binomial;
    }

    public static double cosh(double x) {
        double y = Math.exp(Math.abs(x));
        double ans = Double.isNaN(x) ? Double.NaN : (Double.isInfinite(x) ? x : (y < 9.490626562E7 ? 0.5 * (y + 1.0 / y) : 0.5 * y));
        return ans;
    }

    public static double cot(double x) {
        double ans;
        double pi2rec = 0.011619772367581343;
        double y = Math.abs(x);
        if (y > 4.5036E15) {
            return Double.NaN;
        }
        double ainty = (int)y;
        double yrem = y - ainty;
        double prodbg = 0.625 * ainty;
        ainty = (int)prodbg;
        y = prodbg - ainty + 0.625 * yrem + y * pi2rec;
        double ainty2 = (int)y;
        y -= ainty2;
        int ifn = (int)((ainty += ainty2) % 2.0);
        if (ifn == 1) {
            y = 1.0 - y;
        }
        if (y == 0.0) {
            ans = Double.POSITIVE_INFINITY;
        } else if (y <= 1.82501E-8) {
            ans = 1.0 / y;
        } else if (y <= 0.25) {
            ans = (0.5 + Polynomial.evaluateChebyschev(COT_COEF, 32.0 * y * y - 1.0)) / y;
        } else if (y <= 0.5) {
            ans = (0.5 + Polynomial.evaluateChebyschev(COT_COEF, 8.0 * y * y - 1.0)) / (0.5 * y);
            ans = (ans * ans - 1.0) * 0.5 / ans;
        } else {
            ans = (0.5 + Polynomial.evaluateChebyschev(COT_COEF, 2.0 * y * y - 1.0)) / (0.25 * y);
            ans = (ans * ans - 1.0) * 0.5 / ans;
            ans = (ans * ans - 1.0) * 0.5 / ans;
        }
        if (x != 0.0) {
            ans = ArithUtils.sign(ans, x);
        }
        if (ifn == 1) {
            ans = -ans;
        }
        return ans;
    }

    public static double expm1(double x) {
        double u = Math.exp(x);
        double result = u == 1.0 ? x : (u - 1.0 == -1.0 ? -1.0 : (u - 1.0) * (x / Math.log(u)));
        return result;
    }

    public static int fuzzyCompare(double a, double b, double tolerance) {
        if (a == b) {
            return 0;
        }
        double difference = a - b;
        double maxAbs = Math.max(Math.abs(a), Math.abs(b));
        int exponent = new SplitDouble((double)maxAbs).exponent;
        double delta = tolerance * Math.pow(2.0, exponent);
        int result = 0;
        if (difference > delta) {
            result = 1;
        } else if (difference < -delta) {
            result = -1;
        }
        return result;
    }

    public static double hypot(double a, double b) {
        double r;
        if (Math.abs(a) > Math.abs(b)) {
            r = b / a;
            r = Math.abs(a) * Math.sqrt(1.0 + r * r);
        } else if (b != 0.0) {
            r = a / b;
            r = Math.abs(b) * Math.sqrt(1.0 + r * r);
        } else {
            r = 0.0;
        }
        return r;
    }

    public static boolean isNegativeZero(double x) {
        return x == 0.0 && 1.0 / x < 0.0;
    }

    public static double log2(double x) {
        double result = 0.0;
        if (x > 0.0) {
            result = ArithUtils.safeLog(x) * Constants.LN2INV;
        }
        return result;
    }

    public static double log10(double x) {
        double result = 0.0;
        if (x > 0.0) {
            result = ArithUtils.safeLog(x) * 0.4342944819032518;
        }
        return result;
    }

    public static double log1p(double x) {
        double u = 1.0 + x;
        double result = u == 1.0 ? x : Math.log(u) * (x / (u - 1.0));
        return result;
    }

    public static double logSumLogs(double logX, double logY) {
        return Math.max(logX, logY) + ArithUtils.log1p(Math.exp(-Math.abs(logX - logY)));
    }

    public static double logDiffLogs(double logX, double logY) {
        return logX + ArithUtils.log1p(-Math.exp(logY - logX));
    }

    public static double round(double x, int n) {
        double pow10 = Math.pow(10.0, n);
        return (double)Math.round(x * pow10) / pow10;
    }

    public static double safeLog(double x) {
        if (x == 0.0) {
            return 0.0;
        }
        return Math.log(x);
    }

    public static int sign(int n) {
        if (n > 0) {
            return 1;
        }
        if (n < 0) {
            return -1;
        }
        return 0;
    }

    public static int sign(double d) {
        if (d > 0.0) {
            return 1;
        }
        if (d < 0.0) {
            return -1;
        }
        return 0;
    }

    public static double sign(double x, double y) {
        double abs_x = x < 0.0 ? -x : x;
        return y < 0.0 ? -abs_x : abs_x;
    }

    public static double sinh(double x) {
        double ans;
        double y = Math.abs(x);
        if (Double.isNaN(x)) {
            ans = Double.NaN;
        } else {
            if (Double.isInfinite(y)) {
                return x;
            }
            ans = y < 2.58096E-8 ? x : (y <= 1.0 ? x * (1.0 + Polynomial.evaluateChebyschev(SINH_COEF, 2.0 * x * x - 1.0)) : ((y = Math.exp(y)) >= 9.490626562E7 ? ArithUtils.sign(0.5 * y, x) : ArithUtils.sign(0.5 * (y - 1.0 / y), x)));
        }
        return ans;
    }

    public static double trunc(double x) {
        long lx = (long)x;
        return lx;
    }

    public static double tanh(double x) {
        double ans;
        double y = Math.abs(x);
        if (Double.isNaN(x)) {
            ans = Double.NaN;
        } else if (y < 1.82501E-8) {
            ans = x;
        } else if (y <= 1.0) {
            ans = x * (1.0 + Polynomial.evaluateChebyschev(TANH_COEF, 2.0 * x * x - 1.0));
        } else if (y < 7.977294885) {
            y = Math.exp(y);
            ans = ArithUtils.sign((y - 1.0 / y) / (y + 1.0 / y), x);
        } else {
            ans = ArithUtils.sign(1.0, x);
        }
        return ans;
    }

    protected ArithUtils() {
    }
}

