/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.logger;

import edu.northwestern.at.utils.DebugUtils;
import edu.northwestern.at.utils.logger.Logger;
import edu.northwestern.at.utils.logger.LoggerUtils;

public class StandardErrorLogger
implements Logger {
    protected boolean loggerEnabled = true;
    protected static final String[] errorLevelStrings = new String[]{"FATAL", "ERROR", "WARN ", "INFO ", "DEBUG"};

    public void terminate() {
        this.loggerEnabled = false;
    }

    public void logDebug(String str) {
        this.log(4, str);
    }

    public void logInfo(String str) {
        this.log(3, str);
    }

    public void logWarning(String str) {
        this.log(2, str);
    }

    public void logError(String str) {
        this.log(1, str);
    }

    public void logError(String str, Throwable t) {
        this.log(1, str, t);
    }

    public void logFatal(String str) {
        this.log(0, str);
    }

    public void logFatal(String str, Throwable t) {
        this.log(0, str, t);
    }

    protected static String getErrorLevelString(int level) {
        String result = "?    ";
        if (level >= 0 && level <= 4) {
            result = errorLevelStrings[level];
        }
        return result;
    }

    public void log(int level, String str) {
        System.err.println(LoggerUtils.getFormattedCurrentDateAndTime() + " " + StandardErrorLogger.getErrorLevelString(level) + " - " + str);
    }

    public void log(int level, String str, Throwable t) {
        String stackTrace = DebugUtils.getStackTrace(t);
        String[] stackTraceLines = stackTrace.split("\\n");
        System.err.println(LoggerUtils.getFormattedCurrentDateAndTime() + " " + StandardErrorLogger.getErrorLevelString(level) + " - " + str);
        for (int i = 0; i < stackTraceLines.length; ++i) {
            System.err.println(LoggerUtils.getFormattedCurrentDateAndTime() + " " + "      - " + stackTraceLines[i]);
        }
    }

    public boolean isDebuggingEnabled() {
        return true;
    }

    public boolean isLoggerEnabled() {
        return this.loggerEnabled;
    }
}

