/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.logger;

import edu.northwestern.at.utils.logger.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;

public class BaseLogger
implements Logger {
    protected org.apache.log4j.Logger logger;
    protected boolean loggerEnabled = false;

    public BaseLogger(String logClassName, String logPath, String logConfigFilePath) throws FileNotFoundException, IOException {
        this.logger = org.apache.log4j.Logger.getLogger(logClassName);
        Properties properties = new Properties();
        properties.load(new FileInputStream(logConfigFilePath));
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (!key.startsWith("log4j.appender") || !key.endsWith(".File")) continue;
            String val = properties.getProperty(key);
            val = logPath + File.separatorChar + val;
            properties.setProperty(key, val);
        }
        PropertyConfigurator.configure(properties);
        this.loggerEnabled = true;
    }

    public void terminate() {
        if (this.loggerEnabled) {
            this.loggerEnabled = false;
        }
    }

    protected static Priority mapLevel(int level) {
        switch (level) {
            case 0: {
                return Level.FATAL;
            }
            case 1: {
                return Level.ERROR;
            }
            case 2: {
                return Level.WARN;
            }
            case 3: {
                return Level.INFO;
            }
            case 4: {
                return Level.DEBUG;
            }
        }
        return Level.ERROR;
    }

    public void logDebug(String str) {
        this.logger.log(Level.DEBUG, str);
    }

    public void logInfo(String str) {
        this.logger.log(Level.INFO, str);
    }

    public void logWarning(String str) {
        this.logger.log(Level.WARN, str);
    }

    public void logError(String str) {
        this.logger.log(Level.ERROR, str);
    }

    public void logError(String str, Throwable t) {
        this.logger.log(Level.ERROR, str, t);
    }

    public void logFatal(String str) {
        this.logger.log(Level.FATAL, str);
    }

    public void logFatal(String str, Throwable t) {
        this.logger.log(Level.FATAL, str, t);
    }

    public void log(int level, String str) {
        this.logger.log(BaseLogger.mapLevel(level), str);
    }

    public void log(int level, String str, Throwable t) {
        this.logger.log(BaseLogger.mapLevel(level), str, t);
    }

    public boolean isDebuggingEnabled() {
        return this.logger.isDebugEnabled();
    }

    public boolean isLoggerEnabled() {
        return this.loggerEnabled;
    }
}

