/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.gate;

import edu.northwestern.at.utils.SetFactory;
import gate.AnnotationSet;
import gate.Corpus;
import gate.Factory;
import gate.FeatureMap;
import gate.Gate;
import gate.ProcessingResource;
import gate.corpora.DocumentImpl;
import gate.creole.ANNIEConstants;
import gate.creole.SerialAnalyserController;
import java.io.File;
import java.util.Set;

public class Annie {
    protected SerialAnalyserController annieController;
    protected Corpus corpus;
    protected Set<String> entityTypesWanted;
    protected static String defaultAnnieResourcePath = "data/gate";

    public Annie() throws Exception {
        this.initAnnie(defaultAnnieResourcePath);
    }

    public Annie(String annieResourcePath) throws Exception {
        this.initAnnie(annieResourcePath);
    }

    public void initAnnie(String annieResourcePath) throws Exception {
        Gate.setGateHome((File)new File(annieResourcePath));
        Gate.setPluginsHome((File)new File(annieResourcePath));
        Gate.setUserConfigFile((File)new File(Gate.getGateHome(), "gate.xml"));
        Gate.init();
        Gate.getCreoleRegister().registerDirectories(new File(Gate.getGateHome(), "ANNIE").toURI().toURL());
        this.annieController = (SerialAnalyserController)Factory.createResource((String)"gate.creole.SerialAnalyserController", (FeatureMap)Factory.newFeatureMap(), (FeatureMap)Factory.newFeatureMap(), (String)("ANNIE_" + Gate.genSym()));
        for (int i = 0; i < ANNIEConstants.PR_NAMES.length - 1; ++i) {
            FeatureMap params = Factory.newFeatureMap();
            ProcessingResource processingResource = (ProcessingResource)Factory.createResource((String)ANNIEConstants.PR_NAMES[i], (FeatureMap)params);
            this.annieController.add(processingResource);
        }
        this.corpus = (Corpus)Factory.createResource((String)"gate.corpora.CorpusImpl");
        this.entityTypesWanted = SetFactory.createNewSet();
        this.entityTypesWanted.add("Person");
        this.entityTypesWanted.add("Location");
        this.entityTypesWanted.add("Time");
        this.entityTypesWanted.add("Organization");
        this.entityTypesWanted.add("Date");
        this.entityTypesWanted.add("Money");
    }

    public void close() {
        this.annieController.cleanup();
    }

    public String adornText(String text) {
        String result = "";
        try {
            FeatureMap params = Factory.newFeatureMap();
            DocumentImpl document = (DocumentImpl)Factory.createResource((String)"gate.corpora.DocumentImpl", (FeatureMap)params);
            document.setStringContent(text);
            document.init();
            this.corpus.clear();
            this.corpus.add((Object)document);
            this.annieController.setCorpus(this.corpus);
            this.annieController.execute();
            AnnotationSet adornmentSet = document.getAnnotations().get(this.entityTypesWanted);
            result = document.toXml((Set)adornmentSet, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

