/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.csv;

import edu.northwestern.at.utils.Env;
import edu.northwestern.at.utils.csv.CSVFile;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVFileWriter
extends CSVFile {
    protected OutputStreamWriter outputWriter;

    public CSVFileWriter(String outputFileName, String encoding) throws IOException {
        this.openOutputFile(outputFileName, encoding);
    }

    public CSVFileWriter(String outputFileName, String encoding, char separator) throws IOException {
        super(separator);
        this.openOutputFile(outputFileName, encoding);
    }

    public CSVFileWriter(String outputFileName, String encoding, char separator, char qualifier) throws FileNotFoundException, IOException {
        super(separator, qualifier);
        this.openOutputFile(outputFileName, encoding);
    }

    protected void openOutputFile(String outputFileName, String encoding) throws FileNotFoundException, IOException {
        FileOutputStream outputStream = new FileOutputStream(new File(outputFileName), false);
        BufferedOutputStream bufferedStream = new BufferedOutputStream(outputStream);
        this.outputWriter = encoding != null && encoding.length() > 0 ? new OutputStreamWriter((OutputStream)bufferedStream, encoding) : new OutputStreamWriter(bufferedStream);
    }

    public void close() throws IOException {
        this.outputWriter.flush();
        this.outputWriter.close();
    }

    public void writeValue(String fieldValue) throws IOException {
        boolean addQualifier;
        boolean bl = addQualifier = this.qualifier != '\u0000' && fieldValue.indexOf(this.separator) >= 0;
        if (addQualifier) {
            this.outputWriter.write(this.qualifier);
        }
        this.outputWriter.write(fieldValue == null ? "null" : fieldValue);
        if (addQualifier) {
            this.outputWriter.write(this.qualifier);
        }
    }

    public void writeFields(Object[] fields) throws IOException {
        int n = fields.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                this.outputWriter.write(this.separator);
            }
            this.writeValue(fields[i].toString());
        }
        this.outputWriter.write(Env.LINE_SEPARATOR);
    }

    public void writeFields(List<?> fields) throws IOException {
        int n = fields.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                this.outputWriter.write(this.separator);
            }
            this.writeValue(fields.get(i).toString());
        }
        this.outputWriter.write(Env.LINE_SEPARATOR);
    }

    public void writeFields(List<?> fields, List<Integer> indices) throws IOException {
        if (indices == null || indices.size() == 0) {
            this.writeFields(fields);
            return;
        }
        int nFields = fields.size();
        int nIndices = indices.size();
        int nWritten = 0;
        Iterator<Integer> iterator = indices.iterator();
        while (iterator.hasNext()) {
            String fieldValue = "";
            int j = iterator.next();
            if (j >= 0 && j < nFields) {
                fieldValue = fields.get(j).toString();
            }
            if (nWritten++ > 0) {
                this.outputWriter.write(this.separator);
            }
            this.writeValue(fieldValue);
        }
        this.outputWriter.write(Env.LINE_SEPARATOR);
    }

    public void writeFields(List<?> fields, int[] indices) throws IOException {
        if (indices == null || indices.length == 0) {
            this.writeFields(fields);
            return;
        }
        int nFields = fields.size();
        int nIndices = indices.length;
        int nWritten = 0;
        for (int i = 0; i < nIndices; ++i) {
            String fieldValue = "";
            int j = indices[i];
            if (j >= 0 && j < nFields) {
                fieldValue = fields.get(j).toString();
            }
            if (nWritten++ > 0) {
                this.outputWriter.write(this.separator);
            }
            this.writeValue(fieldValue);
        }
        this.outputWriter.write(Env.LINE_SEPARATOR);
    }

    public void writeEOL() throws IOException {
        this.outputWriter.write(Env.LINE_SEPARATOR);
    }

    public void writeSeparator() throws IOException {
        this.outputWriter.write(this.separator);
    }

    public OutputStreamWriter getOutputWriter() {
        return this.outputWriter;
    }
}

