/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.wordcounts;

import edu.northwestern.at.utils.CharUtils;
import edu.northwestern.at.utils.corpuslinguistics.stopwords.StopWords;
import edu.northwestern.at.utils.corpuslinguistics.wordcounts.WordCountAndSentences;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordCountUtils {
    public static <W extends Comparable> Map<String, WordCountAndSentences> countWordsInSentences(List<List<W>> sentences, StopWords stopWords) {
        TreeMap<String, WordCountAndSentences> wordCounts = new TreeMap<String, WordCountAndSentences>();
        boolean checkStopWords = stopWords != null;
        for (int i = 0; i < sentences.size(); ++i) {
            List<W> sentence = sentences.get(i);
            for (int j = 0; j < sentence.size(); ++j) {
                Comparable word = (Comparable)sentence.get(j);
                String lcWord = word.toString().toLowerCase();
                if (CharUtils.isPunctuationOrSymbol(lcWord) || checkStopWords && stopWords.isStopWord(lcWord)) continue;
                WordCountAndSentences wcs = (WordCountAndSentences)wordCounts.get(lcWord);
                if (wcs == null) {
                    wcs = new WordCountAndSentences((Comparable)((Object)lcWord));
                    wordCounts.put(lcWord, wcs);
                }
                ++wcs.count;
                wcs.sentences.add(i);
            }
        }
        return wordCounts;
    }

    protected WordCountUtils() {
    }
}

