/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.tokenizer;

import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.corpuslinguistics.tokenizer.DefaultWordTokenizer;
import edu.northwestern.at.utils.corpuslinguistics.tokenizer.WordTokenizer;

public class WordTokenizerFactory {
    public WordTokenizer newWordTokenizer() {
        String className = System.getProperty("wordtokenizer.class");
        if (className == null) {
            className = "DefaultWordTokenizer";
        }
        return this.newWordTokenizer(className);
    }

    public WordTokenizer newWordTokenizer(String className) {
        WordTokenizer wordTokenizer = null;
        try {
            wordTokenizer = (WordTokenizer)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(this.getClass().getName()) + "." + className;
            try {
                wordTokenizer = (WordTokenizer)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create word tokenizer of class " + fixedClassName + ", using default.");
                wordTokenizer = new DefaultWordTokenizer();
            }
        }
        return wordTokenizer;
    }
}

