/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.tokenizer;

import edu.northwestern.at.utils.CharUtils;
import edu.northwestern.at.utils.RomanNumeralUtils;
import edu.northwestern.at.utils.corpuslinguistics.tokenizer.Abbreviations;

public class TokenizerUtils {
    public static String getTokenType(String token) {
        String result = "token";
        if (CharUtils.isPunctuation(token)) {
            result = "punctuation";
        } else if (CharUtils.isNumber(token)) {
            result = "number";
        } else if (CharUtils.isUSCurrency(token)) {
            result = "US currency";
        } else if (CharUtils.isUSCurrencyCents(token)) {
            result = "US currency";
        } else if (CharUtils.isCurrency(token)) {
            result = "currency";
        } else if (Abbreviations.isAbbreviation(token)) {
            result = "abbreviation";
        } else if (CharUtils.isSymbol(token)) {
            result = "symbol";
        } else if (RomanNumeralUtils.isRomanNumeral(token) && !token.equals("I")) {
            result = "Roman numeral";
        }
        return result;
    }

    protected TokenizerUtils() {
    }
}

