/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.tokenizer;

import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.corpuslinguistics.tokenizer.DefaultPreTokenizer;
import edu.northwestern.at.utils.corpuslinguistics.tokenizer.PreTokenizer;

public class PreTokenizerFactory {
    public PreTokenizer newPreTokenizer() {
        String className = System.getProperty("pretokenizer.class");
        if (className == null) {
            className = "DefaultPreTokenizer";
        }
        return this.newPreTokenizer(className);
    }

    public PreTokenizer newPreTokenizer(String className) {
        PreTokenizer preTokenizer = null;
        try {
            preTokenizer = (PreTokenizer)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(this.getClass().getName()) + "." + className;
            try {
                preTokenizer = (PreTokenizer)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create pretokenizer of class " + fixedClassName + ", using default.");
                preTokenizer = new DefaultPreTokenizer();
            }
        }
        return preTokenizer;
    }
}

