/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.tokenizer;

import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.corpuslinguistics.tokenizer.DefaultPostTokenizer;
import edu.northwestern.at.utils.corpuslinguistics.tokenizer.PostTokenizer;

public class PostTokenizerFactory {
    public PostTokenizer newPostTokenizer() {
        String className = System.getProperty("posttokenizer.class");
        if (className == null) {
            className = "DefaultPostTokenizer";
        }
        return this.newPostTokenizer(className);
    }

    public PostTokenizer newPostTokenizer(String className) {
        PostTokenizer postTokenizer = null;
        try {
            postTokenizer = (PostTokenizer)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(this.getClass().getName()) + "." + className;
            try {
                postTokenizer = (PostTokenizer)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create posttokenizer of class " + fixedClassName + ", using default.");
                postTokenizer = new DefaultPostTokenizer();
            }
        }
        return postTokenizer;
    }
}

