/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.tokenizer;

import edu.northwestern.at.utils.UTF8Properties;
import edu.northwestern.at.utils.UTF8PropertyUtils;
import java.io.IOException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Abbreviations {
    protected static Pattern abbreviationPattern = Pattern.compile("^([A-Za-z]\\.([A-Za-z0-9]\\.)+|[A-Z]\\.|[A-Z][bcdfghj-np-tvxz]+\\.)$");
    protected static Matcher abbreviationMatcher = abbreviationPattern.matcher("");
    protected static Pattern initialPattern = Pattern.compile("[A-Z][.]");
    protected static Matcher initialMatcher = initialPattern.matcher("");
    protected static Pattern possessiveInitialPattern = Pattern.compile("[A-Z][.]'[s|S]");
    protected static Matcher possessiveInitialMatcher = possessiveInitialPattern.matcher("");
    protected static UTF8Properties abbreviations = null;
    protected static final String defaultAbbreviationsFileName = "resources/abbreviations.txt";

    protected static void loadDefaultAbbreviations() {
        if (abbreviations != null) {
            return;
        }
        abbreviations = new UTF8Properties();
        try {
            abbreviations.load(Abbreviations.class.getResourceAsStream(defaultAbbreviationsFileName));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean loadAbbreviations(String abbreviationsURL) {
        boolean result = false;
        if (abbreviations == null) {
            abbreviations = new UTF8Properties();
        }
        try {
            abbreviations = UTF8PropertyUtils.loadUTF8Properties(new URL(abbreviationsURL), abbreviations);
            result = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static boolean isKnownAbbreviation(String str) {
        return abbreviations.containsKey(str);
    }

    public static boolean isAbbreviation(String str) {
        boolean result = Abbreviations.isKnownAbbreviation(str);
        if (!result) {
            abbreviationMatcher.reset(str);
            result = abbreviationMatcher.matches();
        }
        return result;
    }

    public static boolean isEOSAbbreviation(String str) {
        return abbreviations.getProperty(str, "0").equals("1");
    }

    public static boolean isInitial(String str) {
        initialMatcher.reset(str);
        return initialMatcher.matches();
    }

    public static boolean isPossessiveInitial(String str) {
        possessiveInitialMatcher.reset(str);
        return possessiveInitialMatcher.matches();
    }

    public static int getAbbreviationsCount() {
        int result = 0;
        if (abbreviations != null) {
            result = abbreviations.size();
        }
        return result;
    }

    protected Abbreviations() {
    }

    static {
        Abbreviations.loadDefaultAbbreviations();
    }
}

