/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.thesaurus;

import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.corpuslinguistics.thesaurus.DefaultThesaurus;
import edu.northwestern.at.utils.corpuslinguistics.thesaurus.Thesaurus;

public class ThesaurusFactory {
    public Thesaurus newThesaurus() {
        String className = System.getProperty("thesaurus.class");
        if (className == null) {
            className = "DefaultThesaurus";
        }
        return this.newThesaurus(className);
    }

    public Thesaurus newThesaurus(String className) {
        Thesaurus thesaurus = null;
        try {
            thesaurus = (Thesaurus)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(this.getClass().getName()) + "." + className;
            try {
                thesaurus = (Thesaurus)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create thesaurus of class " + fixedClassName + ", using default.");
                try {
                    thesaurus = new DefaultThesaurus();
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
        }
        return thesaurus;
    }
}

