/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.textsummarizer;

import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.corpuslinguistics.textsummarizer.DefaultTextSummarizer;
import edu.northwestern.at.utils.corpuslinguistics.textsummarizer.TextSummarizer;

public class TextSummarizerFactory {
    public TextSummarizer newTextSummarizer() {
        String className = System.getProperty("summarizer.class");
        if (className == null) {
            className = "DefaultTextSummarizer";
        }
        return this.newTextSummarizer(className);
    }

    public TextSummarizer newTextSummarizer(String className) {
        TextSummarizer summarizer = null;
        try {
            summarizer = (TextSummarizer)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(this.getClass().getName()) + "." + className;
            try {
                summarizer = (TextSummarizer)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create summarizer of class " + fixedClassName + ", using default.");
                try {
                    summarizer = new DefaultTextSummarizer();
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
        }
        return summarizer;
    }
}

