/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.textsegmenter.c99;

import edu.northwestern.at.utils.CharUtils;
import edu.northwestern.at.utils.corpuslinguistics.stemmer.Stemmer;
import edu.northwestern.at.utils.corpuslinguistics.stopwords.StopWords;
import edu.northwestern.at.utils.corpuslinguistics.textsegmenter.struct.ContextVector;
import edu.northwestern.at.utils.corpuslinguistics.textsegmenter.struct.EntropyVector;
import edu.northwestern.at.utils.math.Convolution;
import edu.northwestern.at.utils.math.statistics.Accumulator;
import java.util.Arrays;
import java.util.Vector;

public class C99 {
    protected static int[] boundaries(double[][] m3, int n) {
        int[] result;
        int ie;
        Vector<Region> R = new Vector<Region>();
        Region r = new Region(0, m3.length - 1, m3);
        Region.bestBoundary_max(m3, r);
        R.addElement(r);
        int[] B2 = new int[m3.length - 1];
        double[] dD = new double[m3.length - 1];
        double sum_region = r.sum;
        double sum_area = r.area;
        double D = sum_region / sum_area;
        int index = 0;
        int n2 = ie = n != -1 ? n - 1 : m3.length - 1;
        for (int i = 0; i < ie; ++i) {
            index = 0;
            do {
                r = (Region)R.elementAt(index++);
            } while (index < R.size() && r.start == r.end);
            --index;
            double maxD = 1.4E-45f;
            int j = R.size();
            while (j-- > 0) {
                double tempD;
                r = (Region)R.elementAt(j);
                if (r.start >= r.end || !((tempD = (sum_region - r.sum + r.left.sum + r.right.sum) / (sum_area - (double)r.area + (double)r.left.area + (double)r.right.area)) > maxD)) continue;
                maxD = tempD;
                index = j;
            }
            r = (Region)R.elementAt(index);
            Region.bestBoundary_max(m3, r.left);
            Region.bestBoundary_max(m3, r.right);
            R.setElementAt(r.right, index);
            R.insertElementAt(r.left, index);
            B2[i] = r.right.start;
            dD[i] = maxD - D;
            D = maxD;
            sum_region = sum_region - r.sum + r.left.sum + r.right.sum;
            sum_area = sum_area - (double)r.area + (double)r.left.area + (double)r.right.area;
        }
        if (n != -1) {
            result = new int[n - 1];
            System.arraycopy(B2, 0, result, 0, n - 1);
        } else {
            int number;
            dD = Convolution.convolute(dD, new double[]{1.0, 2.0, 4.0, 8.0, 4.0, 2.0, 1.0});
            Accumulator dist = new Accumulator();
            dist.addValues(dD);
            double threshold = dist.getMean() + 1.2 * dist.getStandardDeviation();
            for (number = 0; number < dD.length && dD[number] > threshold; ++number) {
            }
            result = new int[number];
            System.arraycopy(B2, 0, result, 0, number);
        }
        return result;
    }

    protected static ContextVector[] normalize(String[][] document, StopWords stopWords, Stemmer stemmer) {
        ContextVector[] v = new ContextVector[document.length];
        int i = document.length;
        while (i-- > 0) {
            v[i] = new ContextVector();
            int j = document[i].length;
            while (j-- > 0) {
                String token = document[i][j].toLowerCase();
                if (!CharUtils.isAWord(token) || stopWords.isStopWord(token)) continue;
                String stem = stemmer.stem(token);
                ContextVector.inc(stem, 1, v[i]);
            }
        }
        return v;
    }

    protected static ContextVector[] normalize(String[][] document, ContextVector tf, StopWords stopWords, Stemmer stemmer) {
        ContextVector[] v = new ContextVector[document.length];
        int i = document.length;
        while (i-- > 0) {
            v[i] = new ContextVector();
            int j = document[i].length;
            while (j-- > 0) {
                String token = document[i][j].toLowerCase();
                if (!CharUtils.isAWord(token) || stopWords.isStopWord(token)) continue;
                String stem = stemmer.stem(token);
                ContextVector.inc(stem, 1, v[i]);
                ContextVector.inc(stem, 1, tf);
            }
        }
        return v;
    }

    protected static double[][] rank(double[][] f, int maskSize) {
        double[][] m3 = new double[f.length][f.length];
        int dS = maskSize % 2 == 1 ? maskSize / 2 : (maskSize - 1) / 2;
        int m_i = m3.length;
        while (m_i-- > 0) {
            int m_j = m_i + 1;
            while (m_j-- > 0) {
                double sum;
                int k_je;
                int k_js;
                int k_ie;
                double v = f[m_i][m_j];
                m3[m_i][m_j] = 0.0;
                int k_is = m_i - dS;
                if (k_is < 0) {
                    k_is = 0;
                }
                if ((k_ie = m_i + dS + 1) > f.length) {
                    k_ie = f.length;
                }
                if ((k_js = m_j - dS) < 0) {
                    k_js = 0;
                }
                if ((k_je = m_j + dS + 1) > f.length) {
                    k_je = f.length;
                }
                if ((sum = (double)((k_ie - k_is) * (k_je - k_js) - 1)) > 0.0) {
                    int k_i = k_ie;
                    while (k_i-- > k_is) {
                        int k_j = k_je;
                        while (k_j-- > k_js) {
                            if (!(v > f[k_i][k_j])) continue;
                            double[] dArray = m3[m_i];
                            int n = m_j;
                            dArray[n] = dArray[n] + 1.0;
                        }
                    }
                    double[] dArray = m3[m_i];
                    int n = m_j;
                    dArray[n] = dArray[n] / sum;
                }
                m3[m_j][m_i] = m3[m_i][m_j];
            }
        }
        return m3;
    }

    public static String[][][] segment(String[][] document, int n, int s2, StopWords stopWords, Stemmer stemmer) {
        ContextVector[] vectors = C99.normalize(document, stopWords, stemmer);
        double[][] sim = C99.similarity(vectors);
        vectors = null;
        double[][] rank = C99.rank(sim, s2);
        sim = null;
        double[][] sum = C99.sum(rank);
        rank = null;
        int[] bounds = C99.boundaries(sum, n);
        Arrays.sort(bounds);
        sum = null;
        return C99.split(document, bounds);
    }

    public static String[][][] segmentW(String[][] document, int n, int s2, StopWords stopWords, Stemmer stemmer) {
        ContextVector tf = new ContextVector();
        ContextVector[] vectors = C99.normalize(document, tf, stopWords, stemmer);
        EntropyVector ev = new EntropyVector(tf);
        double[][] sim = C99.similarity(vectors, ev);
        vectors = null;
        double[][] rank = C99.rank(sim, s2);
        sim = null;
        double[][] sum = C99.sum(rank);
        rank = null;
        int[] bounds = C99.boundaries(sum, n);
        Arrays.sort(bounds);
        sum = null;
        return C99.split(document, bounds);
    }

    protected static double[][] similarity(ContextVector[] v) {
        double[][] similarity = new double[v.length][v.length];
        int i = v.length;
        while (i-- > 0) {
            int j = i + 1;
            while (j-- > 0) {
                similarity[i][j] = ContextVector.cos(v[i], v[j]);
                similarity[j][i] = similarity[i][j];
            }
        }
        return similarity;
    }

    protected static double[][] similarity(ContextVector[] v, EntropyVector entropy) {
        double[][] similarity = new double[v.length][v.length];
        int i = v.length;
        while (i-- > 0) {
            int j = i + 1;
            while (j-- > 0) {
                similarity[i][j] = ContextVector.cos(v[i], v[j], entropy);
                similarity[j][i] = similarity[i][j];
            }
        }
        return similarity;
    }

    protected static String[][][] split(String[][] text, int[] boundaries) {
        int[] b = new int[boundaries.length + 2];
        b[0] = 0;
        b[b.length - 1] = text.length;
        System.arraycopy(boundaries, 0, b, 1, boundaries.length);
        String[][][] seg = new String[b.length - 1][][];
        int i = seg.length;
        while (i-- > 0) {
            seg[i] = new String[b[i + 1] - b[i]][];
            System.arraycopy(text, b[i], seg[i], 0, b[i + 1] - b[i]);
        }
        return seg;
    }

    protected static double[][] sum(double[][] rankMatrix) {
        int ip;
        int i;
        double[][] sum = new double[rankMatrix.length][rankMatrix.length];
        int ie = rankMatrix.length;
        for (i = 0; i < ie; ++i) {
            sum[i][i] = rankMatrix[i][i];
        }
        ie = rankMatrix.length - 1;
        for (i = 0; i < ie; ++i) {
            ip = i + 1;
            sum[ip][i] = rankMatrix[ip][i] * 2.0 + sum[i][i] + sum[ip][ip];
            sum[i][ip] = sum[ip][i];
        }
        for (int j = 2; j < rankMatrix.length; ++j) {
            int ie2 = rankMatrix.length - j;
            for (int i2 = 0; i2 < ie2; ++i2) {
                int ij = i2 + j;
                ip = i2 + 1;
                sum[ij][i2] = rankMatrix[ij][i2] * 2.0 + sum[ij - 1][i2] + sum[ij][ip] - sum[ij - 1][ip];
                sum[i2][ij] = sum[ij][i2];
            }
        }
        return sum;
    }

    protected static class Region {
        protected int start;
        protected int end;
        protected int area = 1;
        double sum = 0.0;
        protected Region left = null;
        protected Region right = null;

        public Region(int start, int end, double[][] m3) {
            this.start = start;
            this.end = end;
            this.area = (end - start + 1) * (end - start + 1);
            this.sum = m3[end][start];
        }

        public static void bestBoundary_max(double[][] m3, Region r) {
            int start = r.start;
            int end = r.end;
            if (start < end) {
                int b = start;
                double d_max = 0.0;
                double d = 0.0;
                int i = end;
                int lower = end - start;
                int upper = 1;
                while (i-- > start) {
                    d = (m3[i][start] + m3[end][i + 1]) / (double)(lower * lower + upper * upper);
                    if (d > d_max) {
                        d_max = d;
                        b = i;
                    }
                    --lower;
                    ++upper;
                }
                r.left = new Region(start, b, m3);
                r.right = new Region(b + 1, end, m3);
            }
        }
    }
}

