/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.textsegmenter;

import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.corpuslinguistics.textsegmenter.DefaultTextSegmenter;
import edu.northwestern.at.utils.corpuslinguistics.textsegmenter.TextSegmenter;

public class TextSegmenterFactory {
    public TextSegmenter newTextSegmenter() {
        String className = System.getProperty("segmenter.class");
        if (className == null) {
            className = "DefaultTextSegmenter";
        }
        return this.newTextSegmenter(className);
    }

    public TextSegmenter newTextSegmenter(String className) {
        TextSegmenter segmenter = null;
        try {
            segmenter = (TextSegmenter)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(this.getClass().getName()) + "." + className;
            try {
                segmenter = (TextSegmenter)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create segmenter of class " + fixedClassName + ", using default.");
                try {
                    segmenter = new DefaultTextSegmenter();
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
        }
        return segmenter;
    }
}

