/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.textsegmenter;

import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.corpuslinguistics.textsegmenter.AbstractTextSegmenter;
import edu.northwestern.at.utils.corpuslinguistics.textsegmenter.TextSegmenter;
import edu.northwestern.at.utils.corpuslinguistics.textsegmenter.c99.C99;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class C99TextSegmenter
extends AbstractTextSegmenter
implements TextSegmenter {
    protected int maskSize = 11;
    protected int segmentsWanted = -1;

    public int getMaskSize() {
        return this.maskSize;
    }

    public void setMaskSize(int maskSize) {
        this.maskSize = maskSize;
    }

    public int getSegmentsWanted() {
        return this.segmentsWanted;
    }

    public void setSegmentsWanted(int segmentsWanted) {
        this.segmentsWanted = segmentsWanted;
    }

    @Override
    public <T> List<Integer> getSegmentPositions(List<List<T>> sentences) {
        String[][] docSentences = new String[sentences.size()][];
        for (int i = 0; i < sentences.size(); ++i) {
            List<T> sentence = sentences.get(i);
            docSentences[i] = new String[sentence.size()];
            for (int j = 0; j < sentence.size(); ++j) {
                docSentences[i][j] = sentence.get(j).toString();
            }
        }
        String[][][] segments = C99.segment(docSentences, this.segmentsWanted, this.maskSize, this.stopWords, this.stemmer);
        int segmentCount = segments.length;
        int sentenceIndex = 0;
        List<Integer> result = ListFactory.createNewList();
        for (int i = 0; i < segmentCount; ++i) {
            result.add(sentenceIndex);
            sentenceIndex += segments[i].length;
        }
        return result;
    }
}

