/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.syllablecounter;

import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.corpuslinguistics.syllablecounter.DefaultSyllableCounter;
import edu.northwestern.at.utils.corpuslinguistics.syllablecounter.SyllableCounter;

public class SyllableCounterFactory {
    public SyllableCounter newSyllableCounter() {
        String className = System.getProperty("syllablecounter.class");
        if (className == null) {
            className = "DefaultSyllableCounter";
        }
        return this.newSyllableCounter(className);
    }

    public SyllableCounter newSyllableCounter(String className) {
        SyllableCounter syllablecounter = null;
        try {
            syllablecounter = (SyllableCounter)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(this.getClass().getName()) + "." + className;
            try {
                syllablecounter = (SyllableCounter)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create syllablecounter of class " + fixedClassName + ", using default.");
                try {
                    syllablecounter = new DefaultSyllableCounter();
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
        }
        return syllablecounter;
    }
}

