/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.stringsimilarity;

import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.corpuslinguistics.stringsimilarity.StringSimilarity;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LetterPairSimilarity
implements StringSimilarity {
    protected static String[] letterPairs(String s2) {
        int numPairs = Math.max(s2.length() - 1, 0);
        String[] pairs = new String[numPairs];
        if (numPairs > 0) {
            for (int i = 0; i < numPairs; ++i) {
                pairs[i] = s2.substring(i, i + 2);
            }
        }
        return pairs;
    }

    protected static List<String> wordLetterPairs(String s2) {
        List<String> allPairs = ListFactory.createNewList();
        String[] words = s2.split("\\s");
        for (int w = 0; w < words.length; ++w) {
            String[] pairsInWord = LetterPairSimilarity.letterPairs(words[w]);
            for (int p = 0; p < pairsInWord.length; ++p) {
                allPairs.add(pairsInWord[p]);
            }
        }
        return allPairs;
    }

    public static double letterPairSimilarity(String s1, String s2) {
        List<String> pairs1 = LetterPairSimilarity.wordLetterPairs(s1.toUpperCase());
        List<String> pairs2 = LetterPairSimilarity.wordLetterPairs(s2.toUpperCase());
        int intersection = 0;
        int union = pairs1.size() + pairs2.size();
        block0: for (int i = 0; i < pairs1.size(); ++i) {
            String pair1 = pairs1.get(i);
            for (int j = 0; j < pairs2.size(); ++j) {
                String pair2 = pairs2.get(j);
                if (!pair1.equals(pair2)) continue;
                ++intersection;
                pairs2.remove(j);
                continue block0;
            }
        }
        double result = 0.0;
        if ((double)union >= 0.0) {
            result = 2.0 * (double)intersection / (double)union;
        }
        return result;
    }

    @Override
    public double similarity(String s1, String s2) {
        return LetterPairSimilarity.letterPairSimilarity(s1, s2);
    }
}

