/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.stringsimilarity;

import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.corpuslinguistics.stringsimilarity.StringSimilarity;
import java.util.Map;

public class LetterEquivalence
implements StringSimilarity {
    public static int letterEquivalence(String s1, String s2) {
        int count;
        String c2;
        int i;
        int result = 0;
        if (s1 == null || s2 == null) {
            return result;
        }
        Map<String, Integer> s1Map = MapFactory.createNewMap();
        Map<String, Integer> s2Map = MapFactory.createNewMap();
        for (i = 0; i < s1.length(); ++i) {
            c2 = s1.charAt(i) + "";
            if (s1Map.get(c2) == null) {
                s1Map.put(c2, new Integer(1));
                continue;
            }
            count = (Integer)s1Map.get(c2);
            s1Map.put(c2, new Integer(count + 1));
        }
        for (i = 0; i < s2.length(); ++i) {
            c2 = s2.charAt(i) + "";
            if (s2Map.get(c2) == null) {
                s2Map.put(c2, new Integer(1));
                continue;
            }
            count = (Integer)s2Map.get(c2);
            s2Map.put(c2, new Integer(count + 1));
        }
        for (String c2 : s1Map.keySet()) {
            int count2;
            count = (Integer)s1Map.get(c2);
            if (s2Map.get(c2) == null || count != (count2 = ((Integer)s2Map.get(c2)).intValue())) continue;
            ++result;
        }
        return result;
    }

    public static double letterEquivalenceSimilarity(String s1, String s2) {
        double dl;
        double result = 0.0;
        if (s1 != null && s2 != null && (dl = (double)Math.min(s1.length(), s2.length())) > 0.0) {
            result = (double)LetterEquivalence.letterEquivalence(s1, s2) / dl;
        }
        return result;
    }

    public double similarity(String s1, String s2) {
        return LetterEquivalence.letterEquivalenceSimilarity(s1, s2);
    }
}

