/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.stringsimilarity;

import edu.northwestern.at.utils.corpuslinguistics.stringsimilarity.StringSimilarity;

public class LCS
implements StringSimilarity {
    private static final int NEITHER = 0;
    private static final int UP = 1;
    private static final int LEFT = 2;
    private static final int UP_AND_LEFT = 3;

    public static String LCSAlgorithm(String a, String b) {
        int jj;
        int ii;
        int n = a.length();
        int m3 = b.length();
        int[][] S = new int[n + 1][m3 + 1];
        int[][] R = new int[n + 1][m3 + 1];
        for (ii = 0; ii <= n; ++ii) {
            S[ii][0] = 0;
            R[ii][0] = 1;
        }
        for (jj = 0; jj <= m3; ++jj) {
            S[0][jj] = 0;
            R[0][jj] = 2;
        }
        for (ii = 1; ii <= n; ++ii) {
            for (jj = 1; jj <= m3; ++jj) {
                if (a.charAt(ii - 1) == b.charAt(jj - 1)) {
                    S[ii][jj] = S[ii - 1][jj - 1] + 1;
                    R[ii][jj] = 3;
                } else {
                    S[ii][jj] = S[ii - 1][jj - 1] + 0;
                    R[ii][jj] = 0;
                }
                if (S[ii - 1][jj] >= S[ii][jj]) {
                    S[ii][jj] = S[ii - 1][jj];
                    R[ii][jj] = 1;
                }
                if (S[ii][jj - 1] < S[ii][jj]) continue;
                S[ii][jj] = S[ii][jj - 1];
                R[ii][jj] = 2;
            }
        }
        ii = n;
        jj = m3;
        int pos = S[ii][jj] - 1;
        char[] lcs = new char[pos + 1];
        while (ii > 0 || jj > 0) {
            if (R[ii][jj] == 3) {
                --jj;
                lcs[pos--] = a.charAt(--ii);
                continue;
            }
            if (R[ii][jj] == 1) {
                --ii;
                continue;
            }
            if (R[ii][jj] != 2) continue;
            --jj;
        }
        return new String(lcs);
    }

    public static double lcsSimilarity(String s1, String s2) {
        double dl;
        double result = 0.0;
        if (s1 != null && s2 != null && (dl = (double)(s1.length() + s2.length())) > 0.0) {
            result = 2.0 * (double)LCS.LCSAlgorithm(s1, s2).length() / dl;
        }
        return result;
    }

    public double similarity(String s1, String s2) {
        return LCS.lcsSimilarity(s1, s2);
    }
}

