/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.stopwords;

import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.corpuslinguistics.stopwords.DefaultStopWords;
import edu.northwestern.at.utils.corpuslinguistics.stopwords.StopWords;

public class StopWordsFactory {
    public StopWords newStopWords() {
        String className = System.getProperty("stopwords.class");
        if (className == null) {
            className = "DefaultStopWords";
        }
        return this.newStopWords(className);
    }

    public StopWords newStopWords(String className) {
        StopWords stopwords = null;
        try {
            stopwords = (StopWords)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(this.getClass().getName()) + "." + className;
            try {
                stopwords = (StopWords)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create stopwords of class " + fixedClassName + ", using default.");
                try {
                    stopwords = new DefaultStopWords();
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
        }
        return stopwords;
    }
}

