/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.stemmer;

import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.corpuslinguistics.stemmer.DefaultStemmer;
import edu.northwestern.at.utils.corpuslinguistics.stemmer.Stemmer;

public class StemmerFactory {
    public Stemmer newStemmer() {
        String className = System.getProperty("stemmer.class");
        if (className == null) {
            className = "DefaultStemmer";
        }
        return this.newStemmer(className);
    }

    public Stemmer newStemmer(String className) {
        Stemmer stemmer = null;
        try {
            stemmer = (Stemmer)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(this.getClass().getName()) + "." + className;
            try {
                stemmer = (Stemmer)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create stemmer of class " + fixedClassName + ", using default.");
                try {
                    stemmer = new DefaultStemmer();
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
        }
        return stemmer;
    }
}

