/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.statistics;

import edu.northwestern.at.utils.corpuslinguistics.statistics.BigramLogLikelihood;
import edu.northwestern.at.utils.math.ArithUtils;
import edu.northwestern.at.utils.math.Constants;

public class Collocation {
    public static final int DICE = 0;
    public static final int LOGLIKE = 1;
    public static final int PHISQUARED = 2;
    public static final int SMI = 3;
    public static final int SCP = 4;
    public static final int T = 5;
    public static final int Z = 6;

    public static double[] association(int sampleCount, int refCount, int sampleSize, int refSize) {
        double[] result = new double[7];
        for (int i = 0; i <= 6; ++i) {
            result[i] = 0.0;
        }
        double observed = sampleCount;
        double expected = 0.0;
        double p = 0.0;
        double stdDev = 0.0;
        double ominuse = 0.0;
        if (refSize > 0) {
            p = (double)refCount / (double)refSize;
            expected = p * (double)sampleSize;
            stdDev = Math.sqrt(expected * (1.0 - p));
            ominuse = observed - expected;
        }
        if (stdDev > 0.0) {
            result[6] = ominuse / stdDev;
        }
        if (observed > 0.0) {
            result[5] = ominuse / Math.sqrt(observed);
        }
        if (expected > 0.0) {
            result[3] = ArithUtils.safeLog(observed / expected) / Constants.LN2;
        }
        if (sampleSize + refCount > 0) {
            result[0] = 2.0 * observed / (double)(sampleSize + refCount);
        }
        if (expected > 0.0 && refSize > 0) {
            result[2] = ominuse * ominuse / expected / (double)refSize;
        }
        if (sampleSize * refCount > 0) {
            result[4] = observed * observed / ((double)sampleSize * (double)refCount);
        }
        result[1] = BigramLogLikelihood.calculateLogLikelihood(sampleSize, refCount, observed, refSize);
        return result;
    }

    protected Collocation() {
    }
}

