/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.statistics;

import edu.northwestern.at.utils.math.ArithUtils;

public class BigramLogLikelihood {
    protected static double logLike(double k, double n, double x) {
        return k * ArithUtils.safeLog(x) + (n - k) * ArithUtils.safeLog(1.0 - x);
    }

    public static double calculateLogLikelihood(double c1, double c2, double c12, double n) {
        double p = c2 / n;
        double p1 = c12 / c1;
        double p2 = (c2 - c12) / (n - c1);
        double logLikelihood = BigramLogLikelihood.logLike(c12, c1, p) + BigramLogLikelihood.logLike(c2 - c12, n - c1, p) - BigramLogLikelihood.logLike(c12, c1, p1) - BigramLogLikelihood.logLike(c2 - c12, n - c1, p2);
        logLikelihood = -2.0 * logLikelihood;
        return logLikelihood;
    }

    protected BigramLogLikelihood() {
    }
}

