/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.spellingstandardizer;

import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.corpuslinguistics.spellingstandardizer.DefaultSpellingStandardizer;
import edu.northwestern.at.utils.corpuslinguistics.spellingstandardizer.SpellingStandardizer;

public class SpellingStandardizerFactory {
    public SpellingStandardizer newSpellingStandardizer() {
        String className = System.getProperty("spellingstandardizer.class");
        if (className == null) {
            className = "DefaultSpellingStandardizer";
        }
        return this.newSpellingStandardizer(className);
    }

    public SpellingStandardizer newInitialSpellingStandardizer() {
        String className = System.getProperty("initialspellingstandardizer.class");
        if (className == null) {
            className = "NoopSpellingStandardizer";
        }
        return this.newSpellingStandardizer(className);
    }

    public SpellingStandardizer newSpellingStandardizer(String className) {
        SpellingStandardizer spellingStandardizer = null;
        try {
            spellingStandardizer = (SpellingStandardizer)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(this.getClass().getName()) + "." + className;
            try {
                spellingStandardizer = (SpellingStandardizer)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create spelling standardizer of class " + fixedClassName + ", using default.");
                spellingStandardizer = new DefaultSpellingStandardizer();
            }
        }
        return spellingStandardizer;
    }
}

