/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.spellingstandardizer;

import edu.northwestern.at.morphadorner.servers.standardizerserver.StandardizerServerBootstrap;
import edu.northwestern.at.morphadorner.servers.standardizerserver.StandardizerServerSession;
import edu.northwestern.at.morphadorner.servers.standardizerserver.StandardizerServerSettings;
import edu.northwestern.at.utils.TaggedStrings;
import edu.northwestern.at.utils.corpuslinguistics.spellingstandardizer.SpellingStandardizer;
import edu.northwestern.at.utils.logger.DummyLogger;
import edu.northwestern.at.utils.logger.Logger;
import edu.northwestern.at.utils.logger.UsesLogger;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteSpellingStandardizer
implements SpellingStandardizer,
UsesLogger {
    protected StandardizerServerSession session = null;
    protected Logger logger;

    public RemoteSpellingStandardizer() {
        this.initializeServerSession();
        this.logger = new DummyLogger();
    }

    protected void initializeServerSession() {
        StandardizerServerSettings.initializeSettings();
        try {
            StandardizerServerBootstrap bootstrap = (StandardizerServerBootstrap)Naming.lookup("//localhost:1100/SpellingStandardizer");
            this.session = bootstrap.startSession();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void loadAlternativeSpellings(URL url, String encoding, String delimChars) throws IOException {
    }

    @Override
    public void loadAlternativeSpellingsByWordClass(URL spellingsURL, String encoding) throws IOException {
    }

    @Override
    public void loadAlternativeSpellings(Reader reader, String delimChars) throws IOException {
    }

    @Override
    public void loadStandardSpellings(URL url, String encoding) throws IOException {
    }

    @Override
    public void loadStandardSpellings(Reader reader) throws IOException {
    }

    @Override
    public void addMappedSpelling(String alternateSpelling, String standardSpelling) {
    }

    @Override
    public void addStandardSpelling(String standardSpelling) {
    }

    public void addStandardSpellings(Collection standardSpellings) {
    }

    @Override
    public void setMappedSpellings(TaggedStrings standardMappedSpellings) {
    }

    @Override
    public void setStandardSpellings(Set<String> standardSpellings) {
    }

    @Override
    public String[] standardizeSpelling(String spelling) {
        String[] result = new String[]{spelling};
        if (this.session != null) {
            try {
                result = this.session.standardizeSpelling(spelling);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public String standardizeSpelling(String spelling, String wordClass) {
        String result = spelling;
        if (this.session != null) {
            try {
                result = this.session.standardizeSpelling(spelling, wordClass);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public int getNumberOfAlternateSpellings() {
        int result = 0;
        if (this.session != null) {
            try {
                result = this.session.getNumberOfAlternateSpellings();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public int[] getNumberOfAlternateSpellingsByWordClass() {
        int[] result = new int[]{0, 0};
        if (this.session != null) {
            try {
                result = this.session.getNumberOfAlternateSpellingsByWordClass();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public int getNumberOfStandardSpellings() {
        int result = 0;
        if (this.session != null) {
            try {
                result = this.session.getNumberOfStandardSpellings();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public TaggedStrings getMappedSpellings() {
        return null;
    }

    @Override
    public Set<String> getStandardSpellings() {
        return null;
    }

    @Override
    public String preprocessSpelling(String spelling) {
        return spelling;
    }

    @Override
    public String fixCapitalization(String spelling, String standardSpelling) {
        return standardSpelling;
    }

    public void close() {
        try {
            if (this.session != null) {
                this.session.endSession();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public String toString() {
        return "Remote Spelling Standardizer";
    }
}

