/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.spellingstandardizer;

import edu.northwestern.at.utils.CharUtils;
import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.corpuslinguistics.spellingstandardizer.EnglishDecruftifier;
import edu.northwestern.at.utils.corpuslinguistics.spellingstandardizer.GapFiller;
import edu.northwestern.at.utils.corpuslinguistics.spellingstandardizer.SimpleSpellingStandardizer;
import edu.northwestern.at.utils.corpuslinguistics.spellingstandardizer.SpellingStandardizer;
import java.util.List;

public class ExtendedSimpleSpellingStandardizer
extends SimpleSpellingStandardizer
implements SpellingStandardizer {
    protected GapFiller gapFiller = null;

    protected String fixGaps(String word) {
        List<String> candidates;
        String result = word;
        if (this.gapFiller == null) {
            this.gapFiller = new GapFiller(this.mappedSpellings);
            this.gapFiller.addWords(this.standardSpellingSet);
            if (this.lexicon != null) {
                this.gapFiller.addWords(this.lexicon.getEntries());
            }
        }
        if ((candidates = this.gapFiller.getMatchingWords(result)).size() != 0) {
            if (candidates.size() == 1) {
                result = candidates.get(0);
            } else if (candidates.size() == 2 && candidates.get(0).equalsIgnoreCase(candidates.get(1))) {
                result = candidates.get(0).toLowerCase();
            } else {
                List<String> reducedCandidates = ListFactory.createNewList();
                for (int j = 0; j < candidates.size(); ++j) {
                    String candidate = candidates.get(j);
                    if (!this.standardSpellingSet.contains(candidate)) continue;
                    reducedCandidates.add(candidate);
                }
                if (reducedCandidates.size() == 1) {
                    result = (String)reducedCandidates.get(0);
                }
            }
        }
        return result;
    }

    public String preprocessSpelling(String spelling) {
        String result = EnglishDecruftifier.simpleDecruftify(spelling);
        if (result.endsWith("in'")) {
            result = result.substring(0, result.length() - 3) + "ing";
        }
        if (CharUtils.hasGapMarkers(result)) {
            result = this.fixGaps(result);
        }
        return result;
    }

    protected String[] doStandardizeSpelling(String spelling, boolean addToCache) {
        String result = super.standardizeSpelling(spelling)[0];
        if (!this.standardSpellingSet.contains(result.toLowerCase())) {
            String lowerCaseSpelling = result.toLowerCase();
            result = this.preprocessSpelling(lowerCaseSpelling);
            if (this.mappedSpellings != null) {
                if (this.mappedSpellings.containsString(result)) {
                    result = this.mappedSpellings.getTag(result);
                } else if (addToCache) {
                    this.addCachedSpelling(spelling, result);
                }
            }
        }
        result = this.fixCapitalization(spelling, result);
        return new String[]{result};
    }

    public String[] standardizeSpelling(String spelling) {
        return this.doStandardizeSpelling(spelling, true);
    }

    public String toString() {
        return "English Extended Simple Spelling Standardizer";
    }
}

