/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.spellingstandardizer;

import edu.northwestern.at.utils.CharUtils;
import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.MapUtils;
import edu.northwestern.at.utils.PatternReplacer;
import edu.northwestern.at.utils.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnglishDecruftifier {
    protected static List<PatternReplacer> cmList1 = ListFactory.createNewList();
    protected static List<PatternReplacer> cmList2 = ListFactory.createNewList();
    protected static Pattern vConsonantPattern = Pattern.compile("v([^aeiouy])");
    protected static String vConsonantPatternReplacement = "u$1";
    protected static Pattern vuvPattern = Pattern.compile("([aeiouy])u([aeiouy])");
    protected static String vuvPatternReplacement = "$1v$2";
    protected static Pattern initUVowelPattern = Pattern.compile("^u([aeiouy])");
    protected static String initUVowelPatternReplacement = "v$1";
    protected static Pattern initPrefixvVowelPattern = Pattern.compile("^([ab|ad|con|in|per|re|sub])u([aeiouy])");
    protected static String initPrefixvVowelPatternReplacement = "$1v$2";
    protected static Pattern initIVowelPattern = Pattern.compile("^I([aeiouy])");
    protected static String initIVowelPatternReplacement = "j$1";
    protected static Pattern prefixUVowelPattern = Pattern.compile("^([ab|ad|con|in|per|re|sub])u([aeiouy])");
    protected static String prefixUVowelPatternReplacement = "$1v$2";
    protected static Pattern syllableIsyllablePattern = Pattern.compile("^([ab|ad|con|in|per|re|sub])I([ect|ud|ur|uu|uv|oin|oyn])");
    protected static String syllableIsyllablePatternReplacement = "$1j$2";
    protected static Pattern underlineCapCap = Pattern.compile("^_([ABCDEFGHIJKLMNOPQRSTUVWXYZ])([ABCDEFGHIJKLMNOPQRSTUVWXYZ])");
    protected static String underlineCapCapPatternReplacement = "$1$2";
    protected static Map<String, String> macronMap;
    protected static final String macronMapResourceName = "resources/macronmap.tab";

    protected static void addCombiningMacronPattern(List<PatternReplacer> list, String pattern, String replacement) {
        list.add(new PatternReplacer(pattern, replacement));
    }

    public static String replaceCombiningMacrons(String s2, List<PatternReplacer> cmList) {
        String result = s2;
        if (macronMap.containsKey(s2)) {
            result = macronMap.get(s2);
        } else {
            for (int i = 0; i < cmList.size() && result.indexOf("\u0304") >= 0; ++i) {
                result = cmList.get(i).replace(result);
            }
        }
        return result;
    }

    public static String replacePatterns(String s2, List<PatternReplacer> patternList) {
        String result = s2;
        for (int i = 0; i < patternList.size(); ++i) {
            result = patternList.get(i).replace(result);
        }
        return result;
    }

    public static String fixEnd(String spelling, String ending, String replacement) {
        String result = spelling;
        if (result.endsWith(ending)) {
            result = result.substring(0, result.length() - ending.length()) + replacement;
        }
        return result;
    }

    public static String fixStart1(String spelling, String charsToEvict) {
        String result = spelling;
        if (spelling.length() > 0) {
            for (int i = 0; i < charsToEvict.length(); ++i) {
                if (result.charAt(0) != charsToEvict.charAt(i)) continue;
                result = result.substring(1);
                break;
            }
        }
        return result;
    }

    public static String patternReplacer(Pattern pattern, String result, String replacement) {
        Matcher matcher = pattern.matcher(result);
        if (replacement.length() == 0) {
            while (matcher.find()) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < matcher.groupCount(); ++i) {
                    sb.append(matcher.group(i + 1));
                }
                result = sb.toString();
                matcher = pattern.matcher(result);
            }
        } else {
            result = matcher.replaceAll(replacement);
        }
        return result;
    }

    public static String patternReplacer(String pattern, String result, String replacement) {
        return EnglishDecruftifier.patternReplacer(Pattern.compile(pattern), result, replacement);
    }

    public static CruftySpelling decruftifyStep1(String cruftySpelling) {
        Matcher uCCMatcher;
        String result = cruftySpelling;
        if (result.matches("'s|'S")) {
            return new CruftySpelling(result, true, false);
        }
        if (CharUtils.isAllHyphens(result)) {
            return new CruftySpelling(result, true, false);
        }
        if (CharUtils.isAllAsterisks(result)) {
            return new CruftySpelling(result, true, false);
        }
        if (CharUtils.isPossessiveAsterisks(result)) {
            return new CruftySpelling(result, true, false);
        }
        if (CharUtils.isPossessiveDashes(result)) {
            return new CruftySpelling(result, true, false);
        }
        while (result.startsWith("-")) {
            result = result.substring(1);
        }
        result = StringUtils.replaceAll(result, "[+*^|]", "");
        boolean isAllCaps = CharUtils.allLettersCapital(result = StringUtils.replaceAll(result, "\u18c2", "u"));
        if (isAllCaps) {
            result = CharUtils.capitalizeFirstLetter(result);
        }
        if ((uCCMatcher = underlineCapCap.matcher(result)).find()) {
            String char1 = result.charAt(1) + "";
            String char2 = Character.toLowerCase(result.charAt(2)) + "";
            String rest = "";
            if (result.length() > 3) {
                rest = result.substring(3);
            }
            result = char1 + char2 + rest;
        }
        if ((result = EnglishDecruftifier.replaceCombiningMacrons(result, cmList1)).length() > 1) {
            result = EnglishDecruftifier.fixStart1(result, "*/_^`");
        }
        return new CruftySpelling(result, false, isAllCaps);
    }

    public static CruftySpelling decruftifyStep2(String cruftySpelling) {
        String result = EnglishDecruftifier.replaceCombiningMacrons(cruftySpelling, cmList2);
        return new CruftySpelling(result, false);
    }

    public static CruftySpelling decruftifyStep3(String cruftySpelling) {
        String result = cruftySpelling;
        result = result.replaceAll("yo[~\u0304]$", "ion");
        result = result.replaceAll("cio[~\u0304]$", "cion");
        result = EnglishDecruftifier.fixEnd(result, "cion", "tion");
        result = EnglishDecruftifier.fixEnd(result, "cions", "tions");
        result = EnglishDecruftifier.fixEnd(result, "bld", "bled");
        result = EnglishDecruftifier.fixEnd(result, "ynge", "ing");
        result = EnglishDecruftifier.fixEnd(result, "yng", "ing");
        result = StringUtils.replaceAll(result, "ioin", "join");
        result = StringUtils.replaceAll(result, "ioyn", "join");
        result = StringUtils.replaceAll(result, "nioi", "njoy");
        result = StringUtils.replaceAll(result, "nioy", "njoy");
        result = EnglishDecruftifier.fixEnd(result, "cyal", "cial");
        result = StringUtils.replaceAll(result, "quut", "cut");
        result = StringUtils.replaceAll(result, "vv", "w");
        result = StringUtils.replaceAll(result, "VV", "W");
        result = StringUtils.replaceAll(result, "Vv", "W");
        result = EnglishDecruftifier.patternReplacer("([aeiouy])uu", result, "$1w");
        result = EnglishDecruftifier.patternReplacer("uu([aeiouy])", result, "w$1");
        result = EnglishDecruftifier.patternReplacer(vConsonantPattern, result, vConsonantPatternReplacement);
        result = EnglishDecruftifier.patternReplacer(vuvPattern, result, vuvPatternReplacement);
        result = EnglishDecruftifier.patternReplacer(initUVowelPattern, result, initUVowelPatternReplacement);
        result = EnglishDecruftifier.patternReplacer(initPrefixvVowelPattern, result, initPrefixvVowelPatternReplacement);
        result = EnglishDecruftifier.patternReplacer(initIVowelPattern, result, initIVowelPatternReplacement);
        result = EnglishDecruftifier.patternReplacer(prefixUVowelPattern, result, prefixUVowelPatternReplacement);
        result = EnglishDecruftifier.patternReplacer(syllableIsyllablePattern, result, syllableIsyllablePatternReplacement);
        result = EnglishDecruftifier.fixEnd(result, "mente", "ment");
        result = EnglishDecruftifier.fixEnd(result, "ynde", "ind");
        result = EnglishDecruftifier.patternReplacer("^([^aeiouy])vu", result, "$1uu");
        return new CruftySpelling(result, false);
    }

    public static String decruftify(String cruftySpelling) {
        CruftySpelling fixedSpelling = EnglishDecruftifier.decruftifyStep1(cruftySpelling);
        String result = fixedSpelling.spelling;
        boolean isAllCaps = fixedSpelling.isAllCaps;
        if (!fixedSpelling.done) {
            result = StringUtils.replaceAll(result, "`", "'");
            result = EnglishDecruftifier.fixEnd(result, "'d", "ed");
            result = EnglishDecruftifier.fixEnd(result, "'st", "est");
            result = EnglishDecruftifier.fixEnd(result, "'red", "ered");
            result = EnglishDecruftifier.decruftifyStep2((String)result).spelling;
            result = EnglishDecruftifier.decruftifyStep3((String)result).spelling;
            result = StringUtils.replaceAll(result, "~", "");
            result = StringUtils.replaceAll(result, "_", "");
            result = StringUtils.replaceAll(result, "\u0304", "");
        }
        if (isAllCaps) {
            result = result.toUpperCase();
        }
        return result;
    }

    public static String simpleDecruftify(String cruftySpelling) {
        CruftySpelling fixedSpelling = EnglishDecruftifier.decruftifyStep1(cruftySpelling);
        String result = fixedSpelling.spelling;
        boolean isAllCaps = fixedSpelling.isAllCaps;
        if (!fixedSpelling.done) {
            fixedSpelling = EnglishDecruftifier.decruftifyStep2(result);
            result = fixedSpelling.spelling;
            result = result.replaceAll("cio[~\u0304]$", "cion");
            result = result.replaceAll("yo[~\u0304]$", "yon");
            result = StringUtils.replaceAll(result, "~", "");
            result = StringUtils.replaceAll(result, "_", "");
            result = StringUtils.replaceAll(result, "\u0304", "");
        }
        if (isAllCaps) {
            result = result.toUpperCase();
        }
        return result;
    }

    public static String[] decruftify2(String cruftySpelling) {
        CruftySpelling fixedSpelling = EnglishDecruftifier.decruftifyStep1(cruftySpelling);
        String result1 = fixedSpelling.spelling;
        String result2 = fixedSpelling.spelling;
        boolean isAllCaps = fixedSpelling.isAllCaps;
        if (!fixedSpelling.done) {
            result1 = StringUtils.replaceAll(result1, "`", "'");
            result1 = EnglishDecruftifier.fixEnd(result1, "'d", "ed");
            result1 = EnglishDecruftifier.fixEnd(result1, "'st", "est");
            result1 = EnglishDecruftifier.fixEnd(result1, "'red", "ered");
            result1 = EnglishDecruftifier.decruftifyStep2((String)result1).spelling;
            result1 = EnglishDecruftifier.decruftifyStep3((String)result1).spelling;
            result1 = StringUtils.replaceAll(result1, "~", "");
            result1 = StringUtils.replaceAll(result1, "_", "");
            result1 = StringUtils.replaceAll(result1, "\u0304", "");
            fixedSpelling = EnglishDecruftifier.decruftifyStep2(result2);
            result2 = fixedSpelling.spelling;
            result2 = result2.replaceAll("cio[~\u0304]$", "cion");
            result2 = result2.replaceAll("yo[~\u0304]$", "yon");
            result2 = StringUtils.replaceAll(result2, "~", "");
            result2 = StringUtils.replaceAll(result2, "_", "");
            result2 = StringUtils.replaceAll(result2, "\u0304", "");
        }
        if (isAllCaps) {
            result1 = result1.toUpperCase();
            result2 = result2.toUpperCase();
        }
        return new String[]{result1, result2};
    }

    protected EnglishDecruftifier() {
    }

    static {
        EnglishDecruftifier.addCombiningMacronPattern(cmList1, "a[~\u0304]n", "amn");
        EnglishDecruftifier.addCombiningMacronPattern(cmList1, "so[~\u0304]times", "sometimes");
        EnglishDecruftifier.addCombiningMacronPattern(cmList1, "so[~\u0304]what", "somewhat");
        EnglishDecruftifier.addCombiningMacronPattern(cmList1, "instrue[~\u0304]mt", "instruement");
        EnglishDecruftifier.addCombiningMacronPattern(cmList1, "conte[~\u0304]n", "contemn");
        EnglishDecruftifier.addCombiningMacronPattern(cmList1, "do[~\u0304]$", "dom");
        EnglishDecruftifier.addCombiningMacronPattern(cmList1, "cu[~\u0304]$", "cum");
        EnglishDecruftifier.addCombiningMacronPattern(cmList1, "iu[~\u0304]$", "ium");
        EnglishDecruftifier.addCombiningMacronPattern(cmList1, "unu[~\u0304]$", "unum");
        EnglishDecruftifier.addCombiningMacronPattern(cmList1, "who[~\u0304]e$", "whom");
        EnglishDecruftifier.addCombiningMacronPattern(cmList1, "(ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz)u[~\u0304]$", "$1um");
        EnglishDecruftifier.addCombiningMacronPattern(cmList1, "tyra[~\u0304]n", "tyrann");
        EnglishDecruftifier.addCombiningMacronPattern(cmList1, "tira[~\u0304]n", "tirann");
        EnglishDecruftifier.addCombiningMacronPattern(cmList1, "tu[~\u0304]$", "tum");
        EnglishDecruftifier.addCombiningMacronPattern(cmList1, "tuu[~\u0304]$", "tuum");
        EnglishDecruftifier.addCombiningMacronPattern(cmList1, "ua[~\u0304]", "uam");
        EnglishDecruftifier.addCombiningMacronPattern(cmList1, "uu[~\u0304]$", "uum");
        EnglishDecruftifier.addCombiningMacronPattern(cmList1, "^([tT])he[~\u0304]n", "$1henn");
        EnglishDecruftifier.addCombiningMacronPattern(cmList1, "^([tT])he[~\u0304]c", "$1henc");
        EnglishDecruftifier.addCombiningMacronPattern(cmList1, "^([tT])he[~\u0304]s", "$1hems");
        EnglishDecruftifier.addCombiningMacronPattern(cmList1, "^(tT)he[~\u0304]", "$1hem");
        EnglishDecruftifier.addCombiningMacronPattern(cmList1, "Lo[~\u0304]do[~\u0304]", "London");
        EnglishDecruftifier.addCombiningMacronPattern(cmList1, "Macedo[~\u0304]", "Macedon");
        EnglishDecruftifier.addCombiningMacronPattern(cmList1, "Abraha[~\u0304]", "Abraham");
        EnglishDecruftifier.addCombiningMacronPattern(cmList1, "circu[~\u0304]", "circum");
        EnglishDecruftifier.addCombiningMacronPattern(cmList1, "[~\u0304]([dgknst])", "n$1");
        EnglishDecruftifier.addCombiningMacronPattern(cmList1, "[~\u0304]([bmp])", "m$1");
        EnglishDecruftifier.addCombiningMacronPattern(cmList1, "so[~\u0304]time", "sometime");
        EnglishDecruftifier.addCombiningMacronPattern(cmList1, "^who[~\u0304]$", "whom");
        EnglishDecruftifier.addCombiningMacronPattern(cmList1, "ee[~\u0304]", "eme");
        EnglishDecruftifier.addCombiningMacronPattern(cmList1, "pav[~\u0304]e", "pave");
        EnglishDecruftifier.addCombiningMacronPattern(cmList1, "invo[~\u0304]cat", "invocat");
        EnglishDecruftifier.addCombiningMacronPattern(cmList2, "fro[~\u0304]$", "from");
        EnglishDecruftifier.addCombiningMacronPattern(cmList2, "ice[~\u0304]$", "icem");
        EnglishDecruftifier.addCombiningMacronPattern(cmList2, "ma[~\u0304]$", "man");
        EnglishDecruftifier.addCombiningMacronPattern(cmList2, "me[~\u0304]$", "men");
        EnglishDecruftifier.addCombiningMacronPattern(cmList2, "co[~\u0304]e", "come");
        EnglishDecruftifier.addCombiningMacronPattern(cmList2, "co[~\u0304]for", "comfor");
        EnglishDecruftifier.addCombiningMacronPattern(cmList2, "co[~\u0304]l", "coml");
        EnglishDecruftifier.addCombiningMacronPattern(cmList2, "sco[~\u0304]f", "scomf");
        EnglishDecruftifier.addCombiningMacronPattern(cmList2, "co[~\u0304]", "con");
        EnglishDecruftifier.addCombiningMacronPattern(cmList2, "dde[~\u0304]$", "dden");
        EnglishDecruftifier.addCombiningMacronPattern(cmList2, "ke[~\u0304]$", "ken");
        EnglishDecruftifier.addCombiningMacronPattern(cmList2, "wha[~\u0304]$", "whan");
        EnglishDecruftifier.addCombiningMacronPattern(cmList2, "whe[~\u0304]$", "when");
        EnglishDecruftifier.addCombiningMacronPattern(cmList2, "o[~\u0304]u", "onv");
        EnglishDecruftifier.addCombiningMacronPattern(cmList2, "ione[~\u0304]$", "ionem");
        EnglishDecruftifier.addCombiningMacronPattern(cmList2, "tate[~\u0304]$", "tatem");
        EnglishDecruftifier.addCombiningMacronPattern(cmList2, "nte[~\u0304]", "ntem");
        EnglishDecruftifier.addCombiningMacronPattern(cmList2, "ale[~\u0304]", "alem");
        EnglishDecruftifier.addCombiningMacronPattern(cmList2, "ile[~\u0304]", "ilem");
        EnglishDecruftifier.addCombiningMacronPattern(cmList2, "dine[~\u0304]", "dinem");
        EnglishDecruftifier.addCombiningMacronPattern(cmList2, "gine[~\u0304]", "ginem");
        EnglishDecruftifier.addCombiningMacronPattern(cmList2, "ore[~\u0304]", "orem");
        EnglishDecruftifier.addCombiningMacronPattern(cmList2, "[~\u0304]q", "nq");
        EnglishDecruftifier.addCombiningMacronPattern(cmList2, "[~\u0304]ly", "nly");
        EnglishDecruftifier.addCombiningMacronPattern(cmList2, "ou[~\u0304]", "oun");
        EnglishDecruftifier.addCombiningMacronPattern(cmList2, "io[~\u0304]", "ion");
        EnglishDecruftifier.addCombiningMacronPattern(cmList2, "to[~\u0304]", "ton");
        EnglishDecruftifier.addCombiningMacronPattern(cmList2, "([aeiou])[~\u0304]", "$1n");
        macronMap = MapFactory.createNewMap();
        try {
            macronMap = MapUtils.loadMap(EnglishDecruftifier.class.getResource(macronMapResourceName), "\t", "", "utf-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class CruftySpelling {
        String spelling;
        boolean done;
        boolean isAllCaps;

        public CruftySpelling(String spelling, boolean done, boolean isAllCaps) {
            this.spelling = spelling;
            this.done = done;
            this.isAllCaps = isAllCaps;
        }

        public CruftySpelling(String spelling, boolean done) {
            this.spelling = spelling;
            this.done = done;
        }
    }
}

