/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.spellingmapper;

import edu.northwestern.at.utils.CharUtils;
import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.UnicodeReader;
import edu.northwestern.at.utils.corpuslinguistics.spellingmapper.SpellingMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.StringTokenizer;

public class USToBritishSpellingMapper
implements SpellingMapper {
    protected static final String wordMapPath = "resources/abbc.tab";
    protected static Map<String, String> USToBritMap = null;

    public USToBritishSpellingMapper() {
        if (USToBritMap == null) {
            try {
                USToBritMap = MapFactory.createNewMap();
                this.loadUSToBritishWordMap();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void loadUSToBritishWordMap() throws MalformedURLException, IOException {
        URL wordMapURL = USToBritishSpellingMapper.class.getResource(wordMapPath);
        BufferedReader mapReader = new BufferedReader(new UnicodeReader(wordMapURL.openStream()));
        String line = mapReader.readLine();
        while (line != null) {
            StringTokenizer tokens = new StringTokenizer(line, "\t");
            String usWord = tokens.nextToken().trim();
            String britWord = tokens.nextToken().trim();
            USToBritMap.put(usWord, britWord);
            line = mapReader.readLine();
        }
        mapReader.close();
    }

    public String mapSpelling(String spelling) {
        String result = spelling;
        String usSpelling = USToBritMap.get(spelling.toLowerCase());
        if (usSpelling != null) {
            result = CharUtils.makeCaseMatch(usSpelling, spelling);
        }
        return result;
    }
}

