/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.spellingmapper;

import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.corpuslinguistics.spellingmapper.DefaultSpellingMapper;
import edu.northwestern.at.utils.corpuslinguistics.spellingmapper.SpellingMapper;

public class SpellingMapperFactory {
    public SpellingMapper newSpellingMapper() {
        String className = System.getProperty("spellingmapper.class");
        if (className == null) {
            className = "DefaultSpellingMapper";
        }
        return this.newSpellingMapper(className);
    }

    public SpellingMapper newSpellingMapper(String className) {
        SpellingMapper spellingMapper = null;
        try {
            spellingMapper = (SpellingMapper)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(this.getClass().getName()) + "." + className;
            try {
                spellingMapper = (SpellingMapper)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create spelling mapper of class " + fixedClassName + ", using default.");
                spellingMapper = new DefaultSpellingMapper();
            }
        }
        return spellingMapper;
    }
}

