/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.sentencesplitter;

import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.corpuslinguistics.sentencesplitter.DefaultSentenceSplitterIterator;
import edu.northwestern.at.utils.corpuslinguistics.sentencesplitter.SentenceSplitterIterator;

public class SentenceSplitterIteratorFactory {
    public SentenceSplitterIterator newSentenceSplitterIterator() {
        String className = System.getProperty("sentencesplitteriterator.class");
        if (className == null) {
            className = "DefaultSentenceSplitterIterator";
        }
        return this.newSentenceSplitterIterator(className);
    }

    public SentenceSplitterIterator newSentenceSplitterIterator(String className) {
        SentenceSplitterIterator sentenceSplitterIterator = null;
        try {
            sentenceSplitterIterator = (SentenceSplitterIterator)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(this.getClass().getName()) + "." + className;
            try {
                sentenceSplitterIterator = (SentenceSplitterIterator)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create sentence splitter iterator of class " + fixedClassName + ", using default.");
                sentenceSplitterIterator = new DefaultSentenceSplitterIterator();
            }
        }
        return sentenceSplitterIterator;
    }
}

