/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.sentencesplitter;

import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.corpuslinguistics.sentencesplitter.DefaultSentenceSplitter;
import edu.northwestern.at.utils.corpuslinguistics.sentencesplitter.SentenceSplitter;

public class SentenceSplitterFactory {
    public SentenceSplitter newSentenceSplitter() {
        String className = System.getProperty("sentencesplitter.class");
        if (className == null) {
            className = "DefaultSentenceSplitter";
        }
        return this.newSentenceSplitter(className);
    }

    public SentenceSplitter newSentenceSplitter(String className) {
        SentenceSplitter sentenceExtractor = null;
        try {
            sentenceExtractor = (SentenceSplitter)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(this.getClass().getName()) + "." + className;
            try {
                sentenceExtractor = (SentenceSplitter)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create sentence splitter of class " + fixedClassName + ", using default.");
                sentenceExtractor = new DefaultSentenceSplitter();
            }
        }
        return sentenceExtractor;
    }
}

