/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.sentencesplitter;

import edu.northwestern.at.utils.corpuslinguistics.sentencesplitter.SentenceSplitterIterator;
import java.text.BreakIterator;
import java.util.Locale;

public class BreakIteratorSentenceSplitterIterator
implements SentenceSplitterIterator {
    protected BreakIterator sentenceExtractor;
    protected int start = -1;
    protected int end = -1;
    protected String text;

    public BreakIteratorSentenceSplitterIterator() {
        this.sentenceExtractor = BreakIterator.getSentenceInstance(Locale.US);
    }

    public BreakIteratorSentenceSplitterIterator(Locale locale) {
        this.sentenceExtractor = BreakIterator.getSentenceInstance(locale);
    }

    public BreakIteratorSentenceSplitterIterator(String text) {
        this.sentenceExtractor = BreakIterator.getSentenceInstance(Locale.US);
        this.setText(text);
    }

    public BreakIteratorSentenceSplitterIterator(String text, Locale locale) {
        this.sentenceExtractor = BreakIterator.getSentenceInstance(locale);
        this.setText(text);
    }

    public void setText(String text) {
        this.text = text;
        this.sentenceExtractor.setText(this.text);
        this.start = this.sentenceExtractor.first();
        this.end = this.sentenceExtractor.next();
    }

    public boolean hasNext() {
        return this.end != -1;
    }

    public String next() {
        String result = null;
        if (this.end != -1) {
            result = this.text.substring(this.start, this.end);
            this.start = this.end;
            this.end = this.sentenceExtractor.next();
        }
        return result;
    }

    public String peek() {
        String result = null;
        if (this.end != -1) {
            result = this.text.substring(this.start, this.end);
        }
        return result;
    }
}

