/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.postagger.trigram;

import edu.northwestern.at.utils.Formatters;
import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.Map3D;
import edu.northwestern.at.utils.Map3DFactory;
import edu.northwestern.at.utils.corpuslinguistics.adornedword.AdornedWord;
import edu.northwestern.at.utils.corpuslinguistics.postagger.AbstractPartOfSpeechTagger;
import edu.northwestern.at.utils.corpuslinguistics.postagger.PartOfSpeechTagger;
import edu.northwestern.at.utils.corpuslinguistics.postagger.Viterbi;
import edu.northwestern.at.utils.corpuslinguistics.postagger.smoothing.contextual.ContextualSmootherFactory;
import edu.northwestern.at.utils.corpuslinguistics.postagger.smoothing.lexical.LexicalSmootherFactory;
import edu.northwestern.at.utils.logger.Logger;
import edu.northwestern.at.utils.logger.UsesLogger;
import edu.northwestern.at.utils.math.Probability;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrigramTagger
extends AbstractPartOfSpeechTagger
implements PartOfSpeechTagger {
    protected boolean debug = false;
    protected Map3D<String, String, String, Probability> contextualProbabilities = Map3DFactory.createNewMap3D();
    protected int beamSearchRejections = 0;
    protected Viterbi viterbi = new Viterbi();
    protected int linesTagged = 0;
    protected int wordsTagged = 0;

    public TrigramTagger() {
        this.lexicalSmoother = new LexicalSmootherFactory().newLexicalSmoother();
        this.lexicalSmoother.setPartOfSpeechTagger(this);
        this.contextualSmoother = new ContextualSmootherFactory().newContextualSmoother();
        this.contextualSmoother.setPartOfSpeechTagger(this);
    }

    @Override
    public boolean usesTransitionProbabilities() {
        return true;
    }

    protected void reportEndOfTaggingStats() {
        if (this.debug) {
            this.logger.logDebug("      # of cached lexical probabilties   : " + this.lexicalSmoother.cachedProbabilitiesCount());
            this.logger.logDebug("      # of cached contextual probabilties: " + this.contextualSmoother.cachedProbabilitiesCount());
            this.logger.logDebug("      # of states rejected by beam search: " + this.beamSearchRejections);
            if (this.retagger != null) {
                this.logger.logDebug("      # of corrections applied by rules  : " + this.retagger.getRuleCorrections());
            }
        }
        this.logger.logInfo("      lines: " + Formatters.formatIntegerWithCommas(this.linesTagged) + "; words: " + Formatters.formatIntegerWithCommas(this.wordsTagged));
    }

    @Override
    public List<List<AdornedWord>> tagSentences(List<List<String>> sentences) {
        List<List<AdornedWord>> result = super.tagSentences(sentences);
        this.reportEndOfTaggingStats();
        return result;
    }

    @Override
    public <T extends AdornedWord> List<List<T>> tagAdornedWordSentences(List<List<T>> sentences) {
        List<List<T>> result = super.tagAdornedWordSentences(sentences);
        this.reportEndOfTaggingStats();
        return result;
    }

    @Override
    public <T extends AdornedWord> List<T> tagAdornedWordList(List<T> taggedSentence) {
        this.viterbi.reset();
        List<String> previousTags = ListFactory.createNewList();
        previousTags.add(".");
        List<String> previousPreviousTags = ListFactory.createNewList();
        previousPreviousTags.add(".");
        List<String> tags = null;
        AdornedWord word = null;
        for (int i = 0; i < taggedSentence.size(); ++i) {
            word = (AdornedWord)taggedSentence.get(i);
            tags = this.getTagsForWord(word.getStandardSpelling());
            tags = this.processWord(i, word.getStandardSpelling(), previousPreviousTags, previousTags, tags);
            previousPreviousTags = previousTags;
            previousTags = tags;
        }
        List<String> optimalTags = this.viterbi.optimalTags(taggedSentence.size(), tags);
        for (int i = 0; i < taggedSentence.size(); ++i) {
            word = (AdornedWord)taggedSentence.get(i);
            word.setPartsOfSpeech(optimalTags.get(i));
        }
        this.beamSearchRejections += this.viterbi.getBeamSearchRejections();
        ++this.linesTagged;
        this.wordsTagged += taggedSentence.size();
        if (this.linesTagged % 1000 == 0) {
            this.logger.logInfo("      lines: " + Formatters.formatIntegerWithCommas(this.linesTagged) + "; words: " + Formatters.formatIntegerWithCommas(this.wordsTagged));
        }
        return taggedSentence;
    }

    protected List<String> processWord(int wordIndex, String word, List<String> previousPreviousTags, List<String> previousTags, List<String> tags) {
        this.contextualProbabilities.clear();
        int nTags = tags.size();
        Probability[] lexicalProbs = new Probability[nTags];
        for (int i = 0; i < nTags; ++i) {
            String tagI = tags.get(i);
            lexicalProbs[i] = this.lexicalSmoother.lexicalProbability(word, tagI);
            for (int j = 0; j < previousTags.size(); ++j) {
                String previousTagJ = previousTags.get(j);
                for (int k = 0; k < previousPreviousTags.size(); ++k) {
                    this.contextualProbabilities.put(tagI, previousTagJ, (String)((Object)((Comparable)((Object)previousPreviousTags.get(k)))), this.contextualSmoother.contextualProbability(tagI, previousTagJ, previousPreviousTags.get(k)));
                }
            }
        }
        return this.viterbi.updateScore(wordIndex, lexicalProbs, this.contextualProbabilities, tags, previousTags, previousPreviousTags);
    }

    @Override
    public void setLogger(Logger logger) {
        this.logger = logger;
        ((UsesLogger)((Object)this.lexicalSmoother)).setLogger(logger);
        ((UsesLogger)((Object)this.contextualSmoother)).setLogger(logger);
        this.viterbi.setLogger(logger);
    }

    public String toString() {
        return "Trigram tagger";
    }
}

