/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.corpuslinguistics.postagger.smoothing.contextual;

import edu.northwestern.at.utils.ClassUtils;
import edu.northwestern.at.utils.corpuslinguistics.postagger.smoothing.contextual.ContextualSmoother;
import edu.northwestern.at.utils.corpuslinguistics.postagger.smoothing.contextual.DefaultContextualSmoother;

public class ContextualSmootherFactory {
    public ContextualSmoother newContextualSmoother() {
        String className = System.getProperty("contextualsmoother.class");
        if (className == null) {
            className = "DefaultContextualSmoother";
        }
        return this.newContextualSmoother(className);
    }

    public ContextualSmoother newContextualSmoother(String className) {
        ContextualSmoother contextualSmoother = null;
        try {
            contextualSmoother = (ContextualSmoother)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            String fixedClassName = ClassUtils.packageName(this.getClass().getName()) + "." + className;
            try {
                contextualSmoother = (ContextualSmoother)Class.forName(fixedClassName).newInstance();
            }
            catch (Exception e2) {
                System.err.println("Unable to create contextual smoother of class " + fixedClassName + ", using default.");
                contextualSmoother = new DefaultContextualSmoother();
            }
        }
        return contextualSmoother;
    }
}

